/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.asb.java;

import org.protempa.AbstractAlgorithm;
import org.protempa.AlgorithmArguments;
import org.protempa.AlgorithmParameter;
import org.protempa.Algorithms;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

public final class MinAlgorithm
extends AbstractAlgorithm {
    private static final long serialVersionUID = 6131613237861460023L;

    public MinAlgorithm(Algorithms algorithms, String id) {
        super(algorithms, id);
        this.setParameters(new AlgorithmParameter[]{new AlgorithmParameter("maxThreshold", new ValueComparator[]{ValueComparator.LESS_THAN, ValueComparator.LESS_THAN_OR_EQUAL_TO, ValueComparator.EQUAL_TO}, ValueType.NUMERICALVALUE), new AlgorithmParameter("minThreshold", new ValueComparator[]{ValueComparator.GREATER_THAN, ValueComparator.GREATER_THAN_OR_EQUAL_TO, ValueComparator.EQUAL_TO}, ValueType.NUMERICALVALUE)});
        this.setMinimumNumberOfValues(-1);
    }

    @Override
    public Value compute(Segment<PrimitiveParameter> segment, AlgorithmArguments args) {
        Value minVal = null;
        Value minThreshold = args.value("minThreshold");
        ValueComparator minThresholdComp = args.valueComp("minThreshold");
        Value maxThreshold = args.value("maxThreshold");
        ValueComparator maxThresholdComp = args.valueComp("maxThreshold");
        int n = segment.size();
        for (int i = 0; i < n; ++i) {
            Parameter param = (Parameter)segment.get(i);
            Value val = param.getValue();
            if (minVal != null && minVal.compare(val) != ValueComparator.GREATER_THAN) continue;
            minVal = val;
        }
        if (minVal != null && (minThresholdComp == null || minThreshold == null || minThresholdComp.compare(minVal, minThreshold)) && (maxThresholdComp == null || maxThreshold == null || maxThresholdComp.compare(minVal, maxThreshold))) {
            return BooleanValue.TRUE;
        }
        return null;
    }
}

