/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.arp.javautil.string.StringUtil;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.ProtempaUtil;
import org.protempa.dest.table.AbstractTableColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkValidationFailedException;
import org.protempa.dest.table.TableColumnSpecValidationFailedException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public final class AtLeastNColumnSpec
extends AbstractTableColumnSpec {
    private final int n;
    private final Link[] links;
    private final String columnNameOverride;
    private final String trueOutput;
    private final String falseOutput;

    public AtLeastNColumnSpec(int n, Link[] links) {
        this(null, n, links);
    }

    public AtLeastNColumnSpec(String columnNameOverride, int n, Link[] links) {
        this(columnNameOverride, n, links, "true", "false");
    }

    public AtLeastNColumnSpec(String columnNameOverride, int n, Link[] links, String trueOutput, String falseOutput) {
        this.n = n;
        ProtempaUtil.checkArray(links, "links");
        this.links = (Link[])links.clone();
        this.columnNameOverride = columnNameOverride;
        this.trueOutput = trueOutput;
        this.falseOutput = falseOutput;
    }

    @Override
    public String[] columnNames(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        StringBuilder builder = new StringBuilder();
        if (this.columnNameOverride != null) {
            builder.append(this.columnNameOverride);
        } else {
            builder.append("atleast");
            builder.append(this.n);
            builder.append('(');
            builder.append(this.generateLinksHeaderString(this.links));
            builder.append(')');
        }
        return new String[]{builder.toString()};
    }

    @Override
    public void columnValues(String key, Proposition proposition, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache, Map<String, String> replace, char delimiter, Writer writer) throws IOException {
        List<Proposition> props = this.traverseLinks(this.links, proposition, forwardDerivations, backwardDerivations, references, ksCache);
        String str = props.size() >= this.n ? this.trueOutput : this.falseOutput;
        StringUtil.escapeAndWriteDelimitedColumn((String)str, (char)delimiter, replace, (Writer)writer);
    }

    @Override
    public void validate(KnowledgeSource knowledgeSource) throws TableColumnSpecValidationFailedException, KnowledgeSourceReadException {
        int i = 1;
        for (Link link : this.links) {
            try {
                link.validate(knowledgeSource);
            }
            catch (LinkValidationFailedException ex) {
                throw new TableColumnSpecValidationFailedException("Validation of link " + i + " failed", ex);
            }
            ++i;
        }
    }

    public int getN() {
        return this.n;
    }

    public Link[] getLinks() {
        return this.links;
    }

    public String getColumnNameOverride() {
        return this.columnNameOverride;
    }

    public String getTrueOutput() {
        return this.trueOutput;
    }

    public String getFalseOutput() {
        return this.falseOutput;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnNameOverride == null ? 0 : this.columnNameOverride.hashCode());
        result = 31 * result + (this.falseOutput == null ? 0 : this.falseOutput.hashCode());
        result = 31 * result + Arrays.hashCode(this.links);
        result = 31 * result + this.n;
        result = 31 * result + (this.trueOutput == null ? 0 : this.trueOutput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtLeastNColumnSpec other = (AtLeastNColumnSpec)obj;
        if (this.columnNameOverride == null ? other.columnNameOverride != null : !this.columnNameOverride.equals(other.columnNameOverride)) {
            return false;
        }
        if (this.falseOutput == null ? other.falseOutput != null : !this.falseOutput.equals(other.falseOutput)) {
            return false;
        }
        if (!Arrays.equals(this.links, other.links)) {
            return false;
        }
        if (this.n != other.n) {
            return false;
        }
        return !(this.trueOutput == null ? other.trueOutput != null : !this.trueOutput.equals(other.trueOutput));
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        HashSet result = new HashSet();
        for (Link link : this.links) {
            inPropIds = link.getInferredPropositionIds(knowledgeSource, inPropIds);
            org.arp.javautil.arrays.Arrays.addAll(result, (Object[][])new String[][]{inPropIds});
        }
        return result.toArray(new String[result.size()]);
    }
}

