/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.ProtempaUtil;
import org.protempa.dest.table.LinkValidationFailedException;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.dest.table.Util;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;

public abstract class Link {
    private static final PropertyConstraint[] EMPTY_PROPERTY_CONSTRAINT_ARR = new PropertyConstraint[0];
    private final Set<String> propIdsAsSet;
    private final PropertyConstraint[] constraints;
    private final Comparator<Proposition> comparator;
    private final int fromIndex;
    private final int toIndex;

    Link(String[] propositionIds, PropertyConstraint[] constraints, Comparator<Proposition> comparator, int fromIndex, int toIndex) {
        if (propositionIds == null) {
            this.propIdsAsSet = Collections.emptySet();
        } else {
            ProtempaUtil.checkArrayForNullElement(propositionIds, "propositionIds");
            this.propIdsAsSet = new HashSet<String>();
            for (String propId : propositionIds) {
                this.propIdsAsSet.add(propId.intern());
            }
        }
        if (constraints == null) {
            this.constraints = EMPTY_PROPERTY_CONSTRAINT_ARR;
        } else {
            ProtempaUtil.checkArrayForNullElement(constraints, "constraints");
            this.constraints = (PropertyConstraint[])constraints.clone();
        }
        if (fromIndex >= 0 && toIndex >= 0 && fromIndex >= toIndex) {
            throw new IllegalArgumentException("fromIndex cannot be greater than or equal to toIndex");
        }
        this.comparator = comparator;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public final String[] getPropositionIds() {
        return this.propIdsAsSet.toArray(new String[this.propIdsAsSet.size()]);
    }

    public abstract String[] getInferredPropositionIds(KnowledgeSource var1, String[] var2) throws KnowledgeSourceReadException;

    protected boolean isMatch(Proposition proposition) {
        return this.propIdsAsSet.isEmpty() || this.propIdsAsSet.contains(proposition.getId());
    }

    public final PropertyConstraint[] getConstraints() {
        return (PropertyConstraint[])this.constraints.clone();
    }

    public final Comparator<Proposition> getComparator() {
        return this.comparator;
    }

    public final int getFromIndex() {
        return this.fromIndex;
    }

    public final int getToIndex() {
        return this.toIndex;
    }

    void validate(KnowledgeSource knowledgeSource) throws LinkValidationFailedException, KnowledgeSourceReadException {
        ArrayList<String> invalidPropIds = new ArrayList<String>();
        for (String propId : this.propIdsAsSet) {
            if (knowledgeSource.hasPropositionDefinition(propId)) continue;
            invalidPropIds.add(propId);
        }
        if (!invalidPropIds.isEmpty()) {
            throw new LinkValidationFailedException("Invalid proposition id(s): " + StringUtils.join(invalidPropIds, (String)", "));
        }
    }

    abstract String headerFragment();

    final String createHeaderFragment(String ref) {
        int size = this.propIdsAsSet.size();
        boolean sep1Needed = size > 0 && this.constraints.length > 0;
        String sep1 = sep1Needed ? ", " : "";
        String id = size > 0 ? "id=" : "";
        boolean parenNeeded = size > 0 || this.constraints.length > 0;
        String startParen = parenNeeded ? "(" : "";
        String finishParen = parenNeeded ? ")" : "";
        String range = this.rangeString();
        boolean sep2Needed = sep1Needed && range.length() > 0;
        String sep2 = sep2Needed ? ", " : "";
        return '.' + ref + startParen + id + StringUtils.join(this.propIdsAsSet, (char)',') + sep1 + this.constraintHeaderString(this.constraints) + finishParen + sep2 + range;
    }

    protected final List<Proposition> createResults(List<Proposition> propositions) {
        List<Proposition> result;
        if (propositions != null) {
            if (this.constraints.length > 0) {
                result = new ArrayList<Proposition>();
                for (Proposition prop : propositions) {
                    this.applyPropertyConstraints(prop, result);
                }
            } else {
                result = propositions;
            }
            result = this.applyComparatorAndIndices(result);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private String constraintHeaderString(PropertyConstraint[] constraints) {
        ArrayList<String> constraintsL = new ArrayList<String>(constraints.length);
        for (int i = 0; i < constraints.length; ++i) {
            PropertyConstraint ccc = constraints[i];
            constraintsL.add(ccc.getFormatted());
        }
        return StringUtils.join(constraintsL, (char)',');
    }

    private String rangeString() {
        String range;
        boolean rangeSpecified = this.fromIndex >= 0 || this.toIndex >= 0;
        String string = range = rangeSpecified ? "range=" : "";
        if (rangeSpecified) {
            range = this.fromIndex >= 0 ? range + this.fromIndex : range + 0;
            range = range + ",";
            range = this.toIndex >= 0 ? range + this.toIndex : range + "end";
        }
        return range;
    }

    private List<Proposition> applyComparatorAndIndices(List<Proposition> result) {
        assert (result != null) : "result should not be null in sliceResults";
        if (!result.isEmpty()) {
            if (this.comparator != null) {
                Collections.sort(result, this.comparator);
            }
            if (this.fromIndex >= 0 || this.toIndex >= 0) {
                int resultSize = result.size();
                return result.subList(this.fromIndex >= 0 ? this.fromIndex : 0, this.toIndex >= 0 ? Math.min(this.toIndex, resultSize) : resultSize);
            }
        }
        return result;
    }

    private void applyPropertyConstraints(Proposition prop, Collection<Proposition> result) {
        assert (prop != null) : "prop cannot be null";
        assert (result != null) : "result cannot be null";
        boolean compatible = this.constraintsCheckCompatible(prop, this.constraints);
        if (compatible) {
            result.add(prop);
        }
    }

    private boolean constraintsCheckCompatible(Proposition proposition, PropertyConstraint[] constraints) {
        Logger logger = Util.logger();
        for (PropertyConstraint ccc : constraints) {
            String propName = ccc.getPropertyName();
            Value value = proposition.getProperty(propName);
            if (value != null) {
                ValueComparator vc = ccc.getValueComparator();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Proposition is {0}; Property is {1}; Value is {2}; Comparator: {3}", new Object[]{proposition.getId(), propName, value, vc});
                }
                if (vc.compare(value, ccc.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    abstract Collection<Proposition> traverse(Proposition var1, Map<Proposition, List<Proposition>> var2, Map<Proposition, List<Proposition>> var3, Map<UniqueId, Proposition> var4, KnowledgeSourceCache var5, Set<Proposition> var6);

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparator == null ? 0 : this.comparator.hashCode());
        result = 31 * result + Arrays.hashCode(this.constraints);
        result = 31 * result + this.fromIndex;
        result = 31 * result + (this.propIdsAsSet == null ? 0 : this.propIdsAsSet.hashCode());
        result = 31 * result + this.toIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.comparator == null ? other.comparator != null : !this.comparator.equals(other.comparator)) {
            return false;
        }
        if (!Arrays.equals(this.constraints, other.constraints)) {
            return false;
        }
        if (this.fromIndex != other.fromIndex) {
            return false;
        }
        if (this.propIdsAsSet == null ? other.propIdsAsSet != null : !this.propIdsAsSet.equals(other.propIdsAsSet)) {
            return false;
        }
        return this.toIndex == other.toIndex;
    }
}

