/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.protempa.graph.DirectedGraph;
import org.protempa.graph.Edge;
import org.protempa.graph.Weight;
import org.protempa.graph.WeightFactory;

public final class BellmanFord {
    private BellmanFord() {
    }

    public static Map<?, Weight> calcShortestDistances(Object sourceOrDest, DirectedGraph g, Mode mode) {
        HashMap<Object, Weight> shortestDistances = new HashMap<Object, Weight>(g.size() * 4 / 3 + 1);
        if (BellmanFord.hasNegativeCyclePrivate(sourceOrDest, g, shortestDistances, mode)) {
            return null;
        }
        return shortestDistances;
    }

    public static boolean hasNegativeCycle(Object sourceOrDest, DirectedGraph g, Mode mode) {
        return BellmanFord.calcShortestDistances(sourceOrDest, g, mode) == null;
    }

    private static boolean hasNegativeCyclePrivate(Object sourceOrDest, DirectedGraph g, Map<Object, Weight> shortestDistances, Mode mode) {
        BellmanFord.init(sourceOrDest, g, shortestDistances);
        int edgeCount = g.getEdgeCount();
        Weight[] wc = new Weight[edgeCount << 1];
        Edge[] edges = g.edgesAsArray();
        boolean stale = BellmanFord.relax(g, shortestDistances, wc, edges, mode);
        Weight newDistance = new Weight();
        int wcLengthDiv2 = wc.length >>> 1;
        for (int i = 0; i < edges.length; ++i) {
            Edge e = edges[i];
            if (stale) {
                newDistance.set(shortestDistances.get(mode == Mode.SOURCE ? e.getStart() : e.getFinish()));
            } else {
                newDistance.set(wc[i]);
            }
            newDistance.addToSelf(e.getWeight());
            Weight oldDistance = null;
            oldDistance = stale ? shortestDistances.get(mode == Mode.SOURCE ? e.getFinish() : e.getStart()) : wc[wcLengthDiv2 + i];
            if (oldDistance.compareTo(newDistance) <= 0) continue;
            return true;
        }
        return false;
    }

    private static void init(Object sourceOrDest, DirectedGraph g, Map<Object, Weight> shortestDistances) {
        shortestDistances.put(sourceOrDest, WeightFactory.ZERO);
        Iterator<?> itr = g.iterator();
        while (itr.hasNext()) {
            Object vertex = itr.next();
            if (vertex == sourceOrDest) continue;
            shortestDistances.put(vertex, WeightFactory.POS_INFINITY);
        }
    }

    private static boolean relax(DirectedGraph g, Map<Object, Weight> shortestDistances, Weight[] wc, Edge[] edges, Mode mode) {
        Weight newDistance = new Weight();
        boolean wcStale = true;
        boolean makeStale = false;
        int wcLengthDiv2 = wc.length >>> 1;
        int n = g.size();
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < edges.length; ++j) {
                Weight oldDistance;
                Edge e = edges[j];
                if (wcStale) {
                    wc[j] = shortestDistances.get(mode == Mode.SOURCE ? e.getStart() : e.getFinish());
                }
                newDistance.set(wc[j]);
                newDistance.addToSelf(e.getWeight());
                int jj = wcLengthDiv2 + j;
                if (wcStale) {
                    wc[jj] = shortestDistances.get(mode == Mode.SOURCE ? e.getFinish() : e.getStart());
                }
                if ((oldDistance = wc[jj]).compareTo(newDistance) <= 0) continue;
                shortestDistances.put(mode == Mode.SOURCE ? e.getFinish() : e.getStart(), new Weight(newDistance));
                makeStale = true;
            }
            if (!makeStale) {
                wcStale = false;
            }
            makeStale = false;
        }
        return wcStale;
    }

    public static enum Mode {
        SOURCE,
        DESTINATION;

    }
}

