/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.comparator.MaxFinishTemporalPropositionComparator;
import org.protempa.proposition.comparator.TemporalPropositionIntervalComparator;
import org.protempa.proposition.interval.IntervalUtil;
import org.protempa.proposition.value.Unit;

public class PropositionUtil {
    static final Comparator<TemporalProposition> TEMP_PROP_COMP = new TemporalPropositionIntervalComparator();
    static final Comparator<TemporalProposition> MAX_FINISH_COMP = new MaxFinishTemporalPropositionComparator();

    private PropositionUtil() {
    }

    public static <T extends TemporalProposition> List<T> getView(List<T> params, Long minValid, Long maxValid) {
        if (params != null) {
            if (minValid == null && maxValid == null) {
                return params;
            }
            int min = minValid != null ? PropositionUtil.binarySearchMinStart(params, minValid) : 0;
            int max = maxValid != null ? PropositionUtil.binarySearchMaxFinish(params, maxValid) : params.size();
            return params.subList(min, max);
        }
        return null;
    }

    public static <T extends TemporalProposition> Map<String, List<T>> getView(Map<String, List<T>> paramsByKey, Long minValid, Long maxValid) {
        if (paramsByKey != null) {
            HashMap<String, List<T>> result = new HashMap<String, List<T>>();
            for (Map.Entry<String, List<T>> me : paramsByKey.entrySet()) {
                result.put(me.getKey(), PropositionUtil.getView(me.getValue(), minValid, maxValid));
            }
            return result;
        }
        return null;
    }

    public static <T extends Proposition> Map<String, List<T>> createPropositionMap(List<T> propositions) {
        HashMap<String, List<T>> result = new HashMap<String, List<T>>();
        if (propositions != null) {
            for (Proposition prop : propositions) {
                String propId = prop.getId();
                List<Proposition> ts = null;
                if (result.containsKey(propId)) {
                    ts = (List)result.get(propId);
                } else {
                    ts = new ArrayList();
                    result.put(propId, ts);
                }
                ts.add(prop);
            }
        }
        return result;
    }

    private static int minStartIndexedBinarySearch(List<? extends TemporalProposition> list, long tstamp) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            TemporalProposition midVal = list.get(mid);
            Long minStart = midVal.getInterval().getMinimumStart();
            int n = cmp = minStart != null ? minStart.compareTo(tstamp) : -1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private static <T extends TemporalProposition> int minStartIteratorBinarySearch(List<T> list, long tstamp) {
        int low = 0;
        int high = list.size() - 1;
        ListIterator<T> i = list.listIterator();
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            TemporalProposition midVal = (TemporalProposition)PropositionUtil.iteratorBinarySearchGet(i, mid);
            Long maxStart = midVal.getInterval().getMinimumStart();
            int n = cmp = maxStart != null ? maxStart.compareTo(tstamp) : 1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private static int binarySearchMinStart(List<? extends TemporalProposition> params, long timestamp) {
        if (params.size() < 5000 || params instanceof RandomAccess) {
            return PropositionUtil.minStartIndexedBinarySearch(params, timestamp);
        }
        return PropositionUtil.minStartIteratorBinarySearch(params, timestamp);
    }

    private static int maxFinishIndexedBinarySearch(List<? extends TemporalProposition> list, long tstamp) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            TemporalProposition midVal = list.get(mid);
            Long maxFinish = midVal.getInterval().getMaximumFinish();
            int n = cmp = maxFinish != null ? maxFinish.compareTo(tstamp) : 1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return high + 1;
    }

    private static <T extends TemporalProposition> int maxFinishIteratorBinarySearch(List<T> list, long tstamp) {
        int low = 0;
        int high = list.size() - 1;
        ListIterator<T> i = list.listIterator();
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            TemporalProposition midVal = (TemporalProposition)PropositionUtil.iteratorBinarySearchGet(i, mid);
            Long maxFinish = midVal.getInterval().getMaximumFinish();
            int n = cmp = maxFinish != null ? maxFinish.compareTo(tstamp) : 1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return high + 1;
    }

    private static int binarySearchMaxFinish(List<? extends TemporalProposition> params, long timestamp) {
        if (params.size() < 5000 || params instanceof RandomAccess) {
            return PropositionUtil.maxFinishIndexedBinarySearch(params, timestamp);
        }
        return PropositionUtil.maxFinishIteratorBinarySearch(params, timestamp);
    }

    private static PrimitiveParameter indexedBinarySearch(List<PrimitiveParameter> list, long tstamp) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PrimitiveParameter midVal = list.get(mid);
            long cmp = midVal.getPosition() - tstamp;
            if (cmp < 0L) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0L) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    private static <U extends Unit> PrimitiveParameter iteratorBinarySearch(List<PrimitiveParameter> list, long tstamp) {
        int low = 0;
        int high = list.size() - 1;
        ListIterator<PrimitiveParameter> i = list.listIterator();
        while (low <= high) {
            int mid = low + high >>> 1;
            PrimitiveParameter midVal = PropositionUtil.iteratorBinarySearchGet(i, mid);
            long cmp = midVal.getPosition() - tstamp;
            if (cmp < 0L) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0L) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    private static <T> T iteratorBinarySearchGet(ListIterator<T> i, int index) {
        T obj = null;
        int pos = i.nextIndex();
        if (pos <= index) {
            do {
                obj = i.next();
            } while (pos++ < index);
        } else {
            do {
                obj = i.previous();
            } while (--pos > index);
        }
        return obj;
    }

    public static PrimitiveParameter binarySearch(List<PrimitiveParameter> params, long timestamp) {
        if (params.size() < 5000 || params instanceof RandomAccess) {
            return PropositionUtil.indexedBinarySearch(params, timestamp);
        }
        return PropositionUtil.iteratorBinarySearch(params, timestamp);
    }

    public static long distanceBetween(TemporalProposition firstProp, TemporalProposition secondProp) {
        return PropositionUtil.distanceBetween(firstProp, secondProp, null);
    }

    public static long distanceBetween(TemporalProposition firstProp, TemporalProposition secondProp, Unit units) {
        if (firstProp == null) {
            throw new IllegalArgumentException("firstProp cannot be null");
        }
        if (secondProp == null) {
            throw new IllegalArgumentException("secondProp cannot be null");
        }
        return IntervalUtil.distanceBetween(firstProp.getInterval(), secondProp.getInterval(), units);
    }

    public static String distanceBetweenFormattedShort(TemporalProposition firstProp, TemporalProposition secondProp) {
        return PropositionUtil.distanceBetweenFormattedShort(firstProp, secondProp, null);
    }

    public static String distanceBetweenFormattedShort(TemporalProposition firstProp, TemporalProposition secondProp, Unit units) {
        if (firstProp == null) {
            throw new IllegalArgumentException("firstProp cannot be null");
        }
        if (secondProp == null) {
            throw new IllegalArgumentException("secondProp cannot be null");
        }
        return IntervalUtil.distanceBetweenFormattedShort(firstProp.getInterval(), secondProp.getInterval(), units);
    }

    public static String distanceBetweenFormattedMedium(TemporalProposition firstProp, TemporalProposition secondProp) {
        return PropositionUtil.distanceBetweenFormattedMedium(firstProp, secondProp, null);
    }

    public static String distanceBetweenFormattedMedium(TemporalProposition firstProp, TemporalProposition secondProp, Unit units) {
        if (firstProp == null) {
            throw new IllegalArgumentException("firstProp cannot be null");
        }
        if (secondProp == null) {
            throw new IllegalArgumentException("secondProp cannot be null");
        }
        return IntervalUtil.distanceBetweenFormattedMedium(firstProp.getInterval(), secondProp.getInterval(), units);
    }

    public static String distanceBetweenFormattedLong(TemporalProposition firstProp, TemporalProposition secondProp) {
        return PropositionUtil.distanceBetweenFormattedLong(firstProp, secondProp, null);
    }

    public static String distanceBetweenFormattedLong(TemporalProposition firstProp, TemporalProposition secondProp, Unit units) {
        if (firstProp == null) {
            throw new IllegalArgumentException("firstProp cannot be null");
        }
        if (secondProp == null) {
            throw new IllegalArgumentException("secondProp cannot be null");
        }
        return IntervalUtil.distanceBetweenFormattedLong(firstProp.getInterval(), secondProp.getInterval(), units);
    }
}

