/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.protempa.SourceSystem;
import org.protempa.proposition.DefaultUniqueIdFactory;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.UniqueIdFactory;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Value;

public final class TemporalPrimitiveParameterFactory {
    private final DateFormat dateFormat;
    private final Granularity granularity;
    private final UniqueIdFactory uniqueIdFactory;

    public TemporalPrimitiveParameterFactory(DateFormat dateFormat, Granularity granularity, UniqueIdFactory uniqueIdFactory) {
        this.dateFormat = dateFormat == null ? DateFormat.getDateTimeInstance() : dateFormat;
        this.granularity = granularity;
        this.uniqueIdFactory = uniqueIdFactory != null ? uniqueIdFactory : new DefaultUniqueIdFactory();
    }

    public PrimitiveParameter getInstance(String id, String timestamp, SourceSystem dataSourceType) throws ParseException {
        return this.getInstance(id, timestamp != null ? this.dateFormat.parse(timestamp) : null, dataSourceType);
    }

    public PrimitiveParameter getInstance(String id, String timestamp, Value value, SourceSystem dataSourceType) throws ParseException {
        PrimitiveParameter result = this.getInstance(id, timestamp, dataSourceType);
        result.setValue(value);
        return result;
    }

    public PrimitiveParameter getInstance(String id, Date timestamp, SourceSystem dataSourceType) {
        Long tstampAsPos = AbsoluteTimeGranularityUtil.asPosition(timestamp);
        return this.getInstance(id, tstampAsPos, dataSourceType);
    }

    private PrimitiveParameter getInstance(String id, Long pos, SourceSystem dataSourceType) {
        PrimitiveParameter pp = new PrimitiveParameter(id, this.uniqueIdFactory.getInstance());
        pp.setSourceSystem(dataSourceType);
        if (pos != null) {
            pp.setPosition(pos);
        }
        pp.setGranularity(this.granularity);
        return pp;
    }
}

