/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.NominalValueBuilder;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public final class NominalValue
implements Value,
Comparable<NominalValue>,
Serializable {
    private static final long serialVersionUID = 440118249272295573L;
    private String val;
    private volatile transient int hashCode;
    private static final Map<String, NominalValue> cache = new ReferenceMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NominalValue getInstance(String val) {
        if (val != null && val.length() < 20) {
            NominalValue result;
            Map<String, NominalValue> map = cache;
            synchronized (map) {
                result = cache.get(val);
                if (result == null) {
                    result = new NominalValue(val);
                    cache.put(val, result);
                }
            }
            return result;
        }
        return new NominalValue(val);
    }

    public NominalValue(String val) {
        this.val = val != null ? val : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NominalValue replace() {
        NominalValue result;
        Map<String, NominalValue> map = cache;
        synchronized (map) {
            result = cache.get(this.val);
        }
        if (result != null) {
            return result;
        }
        return this;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.val.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NominalValue other = (NominalValue)obj;
        return this.val.equals(other.val);
    }

    public String getString() {
        return this.val;
    }

    @Override
    public String getFormatted() {
        return this.val;
    }

    @Override
    public ValueType getType() {
        return ValueType.NOMINALVALUE;
    }

    @Override
    public ValueComparator compare(Value o) {
        if (o == null) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        switch (o.getType()) {
            case NOMINALVALUE: {
                NominalValue other = (NominalValue)o;
                int comp = this.compareTo(other);
                return comp > 0 ? ValueComparator.GREATER_THAN : (comp < 0 ? ValueComparator.LESS_THAN : ValueComparator.EQUAL_TO);
            }
            case VALUELIST: {
                ValueList vl = (ValueList)o;
                return vl.contains(this) ? ValueComparator.IN : ValueComparator.NOT_IN;
            }
        }
        return ValueComparator.NOT_EQUAL_TO;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.val);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String tmpVal = (String)s.readObject();
        String string = this.val = tmpVal != null ? tmpVal : "";
        if (tmpVal != null && tmpVal.length() < 20 && !cache.containsKey(tmpVal)) {
            cache.put(tmpVal, this);
        }
    }

    @Override
    public int compareTo(NominalValue t) {
        return this.val.compareTo(t.val);
    }

    @Override
    public NominalValueBuilder asBuilder() {
        return new NominalValueBuilder(this);
    }
}

