/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.util.HashMap;
import java.util.Map;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparatorFormatException;

public enum ValueComparator {
    GREATER_THAN(">"){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return GREATER_THAN == comparator;
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return LESS_THAN == comparator;
        }
    }
    ,
    EQUAL_TO("="){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return EQUAL_TO == comparator;
        }
    }
    ,
    NOT_EQUAL_TO("!="){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return EQUAL_TO != comparator;
        }
    }
    ,
    UNKNOWN("?"){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return UNKNOWN == comparator;
        }
    }
    ,
    GREATER_THAN_OR_EQUAL_TO(">="){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return EQUAL_TO == comparator || GREATER_THAN == comparator || GREATER_THAN_OR_EQUAL_TO == comparator;
        }
    }
    ,
    LESS_THAN_OR_EQUAL_TO("<="){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return EQUAL_TO == comparator || LESS_THAN == comparator || LESS_THAN_OR_EQUAL_TO == comparator;
        }
    }
    ,
    IN("IN"){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return IN == comparator;
        }
    }
    ,
    NOT_IN("NOT_IN"){

        @Override
        public boolean includes(ValueComparator comparator) {
            if (comparator == null) {
                throw new IllegalArgumentException("comparator cannot be null");
            }
            return NOT_IN == comparator;
        }
    };

    private static final Map<String, ValueComparator> compStringToComp;
    private final String name;

    public static ValueComparator parse(String compString) {
        ValueComparator result = compStringToComp.get(compString);
        if (result == null) {
            throw new ValueComparatorFormatException();
        }
        return compStringToComp.get(compString);
    }

    private ValueComparator(String name) {
        this.name = name;
    }

    public abstract boolean includes(ValueComparator var1);

    public boolean compare(Value lhsValue, Value rhsValue) {
        if (lhsValue != null) {
            return this.includes(lhsValue.compare(rhsValue));
        }
        if (rhsValue != null) {
            return NOT_EQUAL_TO.includes(this);
        }
        return EQUAL_TO.includes(this);
    }

    public final String getComparatorString() {
        return this.name;
    }

    static {
        compStringToComp = new HashMap<String, ValueComparator>();
        compStringToComp.put(LESS_THAN.getComparatorString(), LESS_THAN);
        compStringToComp.put(EQUAL_TO.getComparatorString(), EQUAL_TO);
        compStringToComp.put(GREATER_THAN.getComparatorString(), GREATER_THAN);
        compStringToComp.put(LESS_THAN_OR_EQUAL_TO.getComparatorString(), LESS_THAN_OR_EQUAL_TO);
        compStringToComp.put(GREATER_THAN_OR_EQUAL_TO.getComparatorString(), GREATER_THAN_OR_EQUAL_TO);
        compStringToComp.put(NOT_EQUAL_TO.getComparatorString(), NOT_EQUAL_TO);
        compStringToComp.put(IN.getComparatorString(), IN);
        compStringToComp.put(NOT_IN.getComparatorString(), NOT_IN);
        compStringToComp.put(UNKNOWN.getComparatorString(), UNKNOWN);
    }
}

