/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;

public enum ValueType {
    VALUE{
        private ValueType[] parseOrder;

        @Override
        public Value parse(String val) {
            if (this.parseOrder == null) {
                this.parseOrder = new ValueType[]{BOOLEANVALUE, NUMBERVALUE, INEQUALITYNUMBERVALUE, DATEVALUE, VALUELIST, NOMINALVALUE};
            }
            Value result = null;
            for (int i = 0; i < this.parseOrder.length && (result = this.parseOrder[i].parse(val)) == null; ++i) {
            }
            return result;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return true;
        }
    }
    ,
    NOMINALVALUE{

        @Override
        public NominalValue parse(String val) {
            return NominalValue.getInstance(val);
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == NOMINALVALUE;
        }
    }
    ,
    BOOLEANVALUE{

        @Override
        public Value parse(String val) {
            if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
                return Boolean.valueOf(val) != false ? BooleanValue.TRUE : BooleanValue.FALSE;
            }
            return null;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == BOOLEANVALUE;
        }
    }
    ,
    ORDEREDVALUE{

        @Override
        public Value parse(String val) {
            Value result = NUMERICALVALUE.parse(val);
            if (result == null) {
                result = DATEVALUE.parse(val);
            }
            return result;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            ValueType valueType = value.getType();
            return valueType == NUMERICALVALUE || valueType == ORDINALVALUE;
        }
    }
    ,
    INEQUALITYNUMBERVALUE{

        @Override
        public Value parse(String s) {
            if (s != null) {
                String numberString;
                String comparatorString;
                InequalityNumberValue result = null;
                if ((s = s.trim()).startsWith(">=") || s.startsWith("<=")) {
                    comparatorString = s.substring(0, 2);
                    numberString = s.substring(2).trim();
                } else if (s.startsWith(">") || s.startsWith("<")) {
                    comparatorString = s.substring(0, 1);
                    numberString = s.substring(1).trim();
                } else {
                    return null;
                }
                ValueComparator comparator = ValueComparator.parse(comparatorString);
                try {
                    BigDecimal val = new BigDecimal(numberString);
                    result = new InequalityNumberValue(comparator, val);
                }
                catch (NumberFormatException ex) {
                    result = null;
                }
                return result;
            }
            return null;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == INEQUALITYNUMBERVALUE;
        }
    }
    ,
    NUMERICALVALUE{

        @Override
        public Value parse(String val) {
            Value result = NUMBERVALUE.parse(val);
            if (result == null) {
                return INEQUALITYNUMBERVALUE.parse(val);
            }
            return result;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            ValueType valueType = value.getType();
            return valueType == NUMBERVALUE || valueType == INEQUALITYNUMBERVALUE;
        }
    }
    ,
    NUMBERVALUE{
        private Map<String, BigDecimal> cache = new ReferenceMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Value parse(String val) {
            if (val != null) {
                try {
                    BigDecimal bd;
                    String valTrimmed = val.trim();
                    Map<String, BigDecimal> map = this.cache;
                    synchronized (map) {
                        bd = this.cache.get(valTrimmed);
                        if (bd == null) {
                            bd = new BigDecimal(valTrimmed);
                            this.cache.put(valTrimmed, bd);
                        }
                    }
                    return NumberValue.getInstance(bd);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == NUMBERVALUE;
        }
    }
    ,
    ORDINALVALUE{

        @Override
        public Value parse(String val) {
            throw new UnsupportedOperationException("Can't parse an ordinal value");
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == ORDINALVALUE;
        }
    }
    ,
    VALUELIST{

        @Override
        public Value parse(String val) {
            if (val == null) {
                return null;
            }
            if (val.startsWith("[") && val.endsWith("]")) {
                String[] vals = val.substring(1, val.length() - 1).split(",");
                ArrayList<String> mergedInnerLists = new ArrayList<String>(vals.length);
                StringBuilder b = new StringBuilder();
                int refCount = 0;
                for (String str : vals) {
                    String strTrimmed = str.trim();
                    boolean startsWithOpenBracket = strTrimmed.startsWith("[");
                    boolean endsWithCloseBracket = strTrimmed.endsWith("]");
                    if (startsWithOpenBracket && endsWithCloseBracket) {
                        mergedInnerLists.add(strTrimmed);
                        continue;
                    }
                    if (startsWithOpenBracket) {
                        b.append(strTrimmed);
                        ++refCount;
                        continue;
                    }
                    if (endsWithCloseBracket) {
                        b.append(',');
                        b.append(strTrimmed);
                        if (refCount-- != 1) continue;
                        mergedInnerLists.add(b.toString());
                        b.setLength(0);
                        continue;
                    }
                    if (refCount > 0) {
                        b.append(',');
                        b.append(strTrimmed);
                        continue;
                    }
                    mergedInnerLists.add(strTrimmed);
                }
                ArrayList<Value> l = new ArrayList<Value>(vals.length);
                for (String s : mergedInnerLists) {
                    if (s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) {
                        l.add(NOMINALVALUE.parse(s.substring(1, s.length() - 1)));
                        continue;
                    }
                    l.add(VALUE.parse(s));
                }
                return new ValueList(l);
            }
            return null;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == VALUELIST;
        }
    }
    ,
    DATEVALUE{

        @Override
        public DateValue parse(String string) {
            DateValue result;
            if (string != null) {
                DateFormat dateFormat = AbsoluteTimeGranularity.DAY.getShortFormat();
                try {
                    result = DateValue.getInstance(dateFormat.parse(string));
                }
                catch (ParseException ex) {
                    result = null;
                }
            } else {
                result = null;
            }
            return result;
        }

        @Override
        public boolean isInstance(Value value) {
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            return value.getType() == DATEVALUE;
        }
    };


    public abstract boolean isInstance(Value var1);

    public abstract Value parse(String var1);
}

