/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import org.mvel.ConversionException;
import org.protempa.KnowledgeSource;
import org.protempa.proposition.value.Value;
import org.protempa.xml.AbstractConverter;

class AllowedValuesConverter
extends AbstractConverter {
    AllowedValuesConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return Value[].class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Value[] values = (Value[])source;
        if (values == null || values.length == 0) {
            return;
        }
        Class<?> valueClass = values[0].getClass();
        for (Value value : values) {
            if (value.getClass() != valueClass) {
                String msg = "Cannot convert allowed values to XML for mixed types of values that include " + value.getClass().getName() + " and " + valueClass.getName();
                throw new ConversionException(msg);
            }
            this.valueToXML(writer, context, value);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Value> valueList = new ArrayList<Value>();
        while (reader.hasMoreChildren()) {
            valueList.add(this.valueFromXML(reader, context));
        }
        return valueList.toArray(new Value[valueList.size()]);
    }
}

