/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.DistanceBetweenColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.proposition.value.Unit;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.UnitValueConverter;

class DistanceBetweenColumnSpecConverter
extends AbstractConverter {
    private static final String UNIT = "unit";
    private static final String COLUMN_NAME_PREFIX_OVERRIDE = "columnNamePrefixOverride";
    private static final String LINKS = "links";

    DistanceBetweenColumnSpecConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return DistanceBetweenColumnSpec.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Unit unit;
        DistanceBetweenColumnSpec columnSpec = (DistanceBetweenColumnSpec)source;
        String columnNameOverride = columnSpec.getColumnNamePrefixOverride();
        if (columnNameOverride != null) {
            writer.addAttribute(COLUMN_NAME_PREFIX_OVERRIDE, columnNameOverride);
        }
        if ((unit = columnSpec.getUnits()) != null) {
            UnitValueConverter unitConverter = new UnitValueConverter();
            writer.addAttribute(UNIT, unitConverter.toString(unit));
        }
        writer.startNode(LINKS);
        context.convertAnother((Object)columnSpec.getLinks());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String columnNameOverride = reader.getAttribute(COLUMN_NAME_PREFIX_OVERRIDE);
        Unit unit = this.unitAttributeValue(reader, UNIT);
        reader.moveDown();
        this.expect(reader, LINKS);
        Link[] links = (Link[])context.convertAnother(null, Link[].class);
        reader.moveUp();
        this.expectNoMore(reader);
        return new DistanceBetweenColumnSpec(columnNameOverride, links, unit);
    }
}

