/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.Derivation;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.Reference;
import org.protempa.xml.AbstractConverter;

class LinksConverter
extends AbstractConverter {
    private static final String REFERENCE = "reference";
    private static final String DERIVATION = "derivation";
    private static final HashSet<String> linkTags = new HashSet();

    LinksConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return Link[].class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Link[] links;
        for (Link link : links = (Link[])source) {
            if (link instanceof Derivation) {
                writer.startNode(DERIVATION);
            } else if (link instanceof Reference) {
                writer.startNode(REFERENCE);
            }
            context.convertAnother((Object)link);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        this.expectChildren(reader);
        ArrayList<Link> linkList = new ArrayList<Link>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String tag = this.expect(reader, linkTags);
            if (DERIVATION.equals(tag)) {
                linkList.add((Derivation)context.convertAnother(null, Derivation.class));
            } else {
                linkList.add((Reference)context.convertAnother(null, Reference.class));
            }
            reader.moveUp();
        }
        return linkList.toArray(new Link[linkList.size()]);
    }

    static {
        linkTags.add(DERIVATION);
        linkTags.add(REFERENCE);
    }
}

