/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.mvel.ConversionException;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.ValueComparatorValueConverter;

class PropertyConstraintConverter
extends AbstractConverter {
    private static final String COMPARATOR = "comparator";
    private static final String PROPERTY_NAME = "propertyName";

    PropertyConstraintConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return PropertyConstraint.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        PropertyConstraint constraint = (PropertyConstraint)source;
        writer.addAttribute(PROPERTY_NAME, constraint.getPropertyName());
        ValueComparatorValueConverter comparatorConverter = new ValueComparatorValueConverter();
        ValueComparator comparator = constraint.getValueComparator();
        String comparatorString = comparatorConverter.toString((Object)comparator);
        writer.addAttribute(COMPARATOR, comparatorString);
        Value value = constraint.getValue();
        if (value instanceof ValueList) {
            if (!this.isAListComparator(comparator)) {
                String msg = "Unsupported conversion of a PropertyConstraint that has a ValueList with the comparator " + comparator.toString();
                throw new ConversionException(msg);
            }
            for (Value thisValue : (ValueList)value) {
                this.valueToXML(writer, context, thisValue);
            }
        } else {
            if (this.isAListComparator(comparator)) {
                String msg = "Unsupported conversion of a PropertyConstraint that does not use a ValueList with the comparator " + comparator.toString();
                throw new ConversionException(msg);
            }
            this.valueToXML(writer, context, value);
        }
    }

    private boolean isAListComparator(ValueComparator comparator) {
        return ValueComparator.IN.equals((Object)comparator) || ValueComparator.NOT_IN.equals((Object)comparator);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ValueList value;
        String propertyName = this.requiredAttributeValue(reader, PROPERTY_NAME);
        String comparatorString = this.requiredAttributeValue(reader, COMPARATOR);
        this.expectChildren(reader);
        ValueComparatorValueConverter comparatorConverter = new ValueComparatorValueConverter();
        ValueComparator comparator = (ValueComparator)((Object)comparatorConverter.fromString(comparatorString));
        if (this.isAListComparator(comparator)) {
            ValueList vlist = new ValueList();
            do {
                vlist.add(this.valueFromXML(reader, context));
            } while (reader.hasMoreChildren());
            value = vlist;
        } else {
            value = this.valueFromXML(reader, context);
            this.expectNoMore(reader);
        }
        return new PropertyConstraint(propertyName, comparator, value);
    }
}

