/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Unit;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.UnitValueConverter;

class RelationConverter
extends AbstractConverter {
    private static final String MAX_DISTANCE_BETWEEN_FINISHES = "maxDistanceBetweenFinishes";
    private static final String MIN_DISTANCE_BETWEEN_FINISHES = "minDistanceBetweenFinishes";
    private static final String MAX_DISTANCE_BETWEEN = "maxDistanceBetween";
    private static final String MIN_DISTANCE_BETWEEN = "minDistanceBetween";
    private static final String MAX_SPAN = "maxSpan";
    private static final String MIN_SPAN = "minSpan";
    private static final String MAX_DISTANCE_BETWEEN_STARTS = "maxDistanceBetweenStarts";
    private static final String UNIT = "unit";
    private static final String LENGTH = "length";
    private static final String MIN_DISTANCE_BETWEEN_STARTS = "minDistanceBetweenStarts";
    private UnitValueConverter unitConverter = new UnitValueConverter();

    RelationConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return Relation.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Relation relation = (Relation)source;
        if (relation.getMinDistanceBetweenStarts() != null || relation.getMinDistanceBetweenStartsUnits() != null) {
            writer.startNode(MIN_DISTANCE_BETWEEN_STARTS);
            this.addDurationAttributes(writer, relation.getMinDistanceBetweenStarts(), relation.getMinDistanceBetweenStartsUnits());
            writer.endNode();
        }
        if (relation.getMaxDistanceBetweenStarts() != null || relation.getMaxDistanceBetweenStartsUnits() != null) {
            writer.startNode(MAX_DISTANCE_BETWEEN_STARTS);
            this.addDurationAttributes(writer, relation.getMaxDistanceBetweenStarts(), relation.getMaxDistanceBetweenStartsUnits());
            writer.endNode();
        }
        if (relation.getMinSpan() != null || relation.getMinSpanUnits() != null) {
            writer.startNode(MIN_SPAN);
            this.addDurationAttributes(writer, relation.getMinSpan(), relation.getMinSpanUnits());
            writer.endNode();
        }
        if (relation.getMaxSpan() != null || relation.getMaxSpanUnits() != null) {
            writer.startNode(MAX_SPAN);
            this.addDurationAttributes(writer, relation.getMaxSpan(), relation.getMaxSpanUnits());
            writer.endNode();
        }
        if (relation.getMinDistanceBetween() != null || relation.getMinDistanceBetweenUnits() != null) {
            writer.startNode(MIN_DISTANCE_BETWEEN);
            this.addDurationAttributes(writer, relation.getMinDistanceBetween(), relation.getMinDistanceBetweenUnits());
            writer.endNode();
        }
        if (relation.getMaxDistanceBetween() != null || relation.getMaxDistanceBetweenUnits() != null) {
            writer.startNode(MAX_DISTANCE_BETWEEN);
            this.addDurationAttributes(writer, relation.getMaxDistanceBetween(), relation.getMaxDistanceBetweenUnits());
            writer.endNode();
        }
        if (relation.getMinDistanceBetweenFinishes() != null || relation.getMinDistanceBetweenFinishesUnits() != null) {
            writer.startNode(MIN_DISTANCE_BETWEEN_FINISHES);
            this.addDurationAttributes(writer, relation.getMinDistanceBetweenFinishes(), relation.getMinDistanceBetweenFinishesUnits());
            writer.endNode();
        }
        if (relation.getMaxDistanceBetweenFinishes() != null || relation.getMaxDistanceBetweenFinishesUnits() != null) {
            writer.startNode(MAX_DISTANCE_BETWEEN_FINISHES);
            this.addDurationAttributes(writer, relation.getMaxDistanceBetweenFinishes(), relation.getMaxDistanceBetweenFinishesUnits());
            writer.endNode();
        }
    }

    private void addDurationAttributes(HierarchicalStreamWriter writer, Integer length, Unit unit) {
        if (length != null) {
            writer.addAttribute(LENGTH, Integer.toString(length));
        }
        if (unit != null) {
            writer.addAttribute(UNIT, this.unitConverter.toString(unit));
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Integer minDistanceBetweenStarts = null;
        Unit minDistanceBetweenStartsUnits = null;
        Integer maxDistanceBetweenStarts = null;
        Unit maxDistanceBetweenStartsUnits = null;
        Integer minSpan = null;
        Unit minSpanUnits = null;
        Integer maxSpan = null;
        Unit maxSpanUnits = null;
        Integer minDistanceBetween = null;
        Unit minDistanceBetweenUnits = null;
        Integer maxDistanceBetween = null;
        Unit maxDistanceBetweenUnits = null;
        Integer minDistanceBetweenFinishes = null;
        Unit minDistanceBetweenFinishesUnits = null;
        Integer maxDistanceBetweenFinishes = null;
        Unit maxDistanceBetweenFinishesUnits = null;
        while (reader.hasMoreChildren()) {
            String elementName;
            reader.moveDown();
            switch (elementName = reader.getNodeName()) {
                case "minDistanceBetweenStarts": {
                    minDistanceBetweenStarts = this.integerAttributeValue(reader, LENGTH);
                    minDistanceBetweenStartsUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "maxDistanceBetweenStarts": {
                    maxDistanceBetweenStarts = this.integerAttributeValue(reader, LENGTH);
                    maxDistanceBetweenStartsUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "minSpan": {
                    minSpan = this.integerAttributeValue(reader, LENGTH);
                    minSpanUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "maxSpan": {
                    maxSpan = this.integerAttributeValue(reader, LENGTH);
                    maxSpanUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "minDistanceBetween": {
                    minDistanceBetween = this.integerAttributeValue(reader, LENGTH);
                    minDistanceBetweenUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "maxDistanceBetween": {
                    maxDistanceBetween = this.integerAttributeValue(reader, LENGTH);
                    maxDistanceBetweenUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "minDistanceBetweenFinishes": {
                    minDistanceBetweenFinishes = this.integerAttributeValue(reader, LENGTH);
                    minDistanceBetweenFinishesUnits = this.unitAttributeValue(reader, UNIT);
                    break;
                }
                case "maxDistanceBetweenFinishes": {
                    maxDistanceBetweenFinishes = this.integerAttributeValue(reader, LENGTH);
                    maxDistanceBetweenFinishesUnits = this.unitAttributeValue(reader, UNIT);
                }
            }
            reader.moveUp();
        }
        return new Relation(minDistanceBetweenStarts, minDistanceBetweenStartsUnits, maxDistanceBetweenStarts, maxDistanceBetweenStartsUnits, minSpan, minSpanUnits, maxSpan, maxSpanUnits, minDistanceBetween, minDistanceBetweenUnits, maxDistanceBetween, maxDistanceBetweenUnits, minDistanceBetweenFinishes, minDistanceBetweenFinishesUnits, maxDistanceBetweenFinishes, maxDistanceBetweenFinishesUnits);
    }
}

