/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import org.protempa.KnowledgeSource;
import org.protempa.xml.AbstractConverter;

class StringArrayConverter
extends AbstractConverter {
    private String elementName;

    StringArrayConverter(String elementName, KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
        this.elementName = elementName;
    }

    public boolean canConvert(Class clazz) {
        return String[].class.equals((Object)clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        String[] keyIDs;
        for (String keyID : keyIDs = (String[])value) {
            writer.startNode(this.elementName);
            writer.setValue(keyID);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<String> keyIdList = new ArrayList<String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.expect(reader, this.elementName);
            keyIdList.add(reader.getValue());
            reader.moveUp();
        }
        return keyIdList.toArray(new String[keyIdList.size()]);
    }
}

