/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.AtLeastNColumnSpec;
import org.protempa.dest.table.CountColumnSpec;
import org.protempa.dest.table.DistanceBetweenColumnSpec;
import org.protempa.dest.table.PropositionColumnSpec;
import org.protempa.dest.table.PropositionValueColumnSpec;
import org.protempa.dest.table.TableColumnSpec;
import org.protempa.xml.AbstractConverter;

class TableColumnSpecsConverter
extends AbstractConverter {
    private static final String PROPOSITION_VALUE_COLUMN_SPEC = "propositionValueColumnSpec";
    private static final String PROPOSITION_COLUMN_SPEC = "propositionColumnSpec";
    private static final String DISTANCE_BETWEEN_COLUMN_SPEC = "distanceBetweenColumnSpec";
    private static final String COUNT_COLUMN_SPEC = "countColumnSpec";
    private static final String AT_LEAST_N_COLUMN_SPEC = "atLeastNColumnSpec";
    private static final HashMap<String, Class<?>> tagToClassMap = new HashMap();

    TableColumnSpecsConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class clazz) {
        return TableColumnSpec[].class.equals((Object)clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        TableColumnSpec[] columnSpecs;
        for (TableColumnSpec columnSpec : columnSpecs = (TableColumnSpec[])value) {
            if (columnSpec instanceof AtLeastNColumnSpec) {
                writer.startNode(AT_LEAST_N_COLUMN_SPEC);
            } else if (columnSpec instanceof CountColumnSpec) {
                writer.startNode(COUNT_COLUMN_SPEC);
            } else if (columnSpec instanceof DistanceBetweenColumnSpec) {
                writer.startNode(DISTANCE_BETWEEN_COLUMN_SPEC);
            } else if (columnSpec instanceof PropositionColumnSpec) {
                writer.startNode(PROPOSITION_COLUMN_SPEC);
            } else if (columnSpec instanceof PropositionValueColumnSpec) {
                writer.startNode(PROPOSITION_VALUE_COLUMN_SPEC);
            } else {
                throw new ConversionException("TableColumnSpecs array contains instance of unsupported class: " + columnSpec.getClass().getName());
            }
            context.convertAnother((Object)columnSpec);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        this.expectChildren(reader);
        ArrayList<TableColumnSpec> tablecolumnSpecList = new ArrayList<TableColumnSpec>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.expect(reader, tagToClassMap.keySet());
            tablecolumnSpecList.add((TableColumnSpec)context.convertAnother(null, tagToClassMap.get(reader.getNodeName())));
            reader.moveUp();
        }
        return tablecolumnSpecList.toArray(new TableColumnSpec[tablecolumnSpecList.size()]);
    }

    static {
        tagToClassMap.put(AT_LEAST_N_COLUMN_SPEC, AtLeastNColumnSpec.class);
        tagToClassMap.put(COUNT_COLUMN_SPEC, CountColumnSpec.class);
        tagToClassMap.put(DISTANCE_BETWEEN_COLUMN_SPEC, DistanceBetweenColumnSpec.class);
        tagToClassMap.put(PROPOSITION_COLUMN_SPEC, PropositionColumnSpec.class);
        tagToClassMap.put(PROPOSITION_VALUE_COLUMN_SPEC, PropositionValueColumnSpec.class);
    }
}

