/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.BufferedWriter;
import java.net.URL;
import org.mvel.ConversionException;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.TableColumnSpec;
import org.protempa.dest.table.TableDestination;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.PropIDsConverter;
import org.protempa.xml.TableColumnSpecsConverter;
import org.protempa.xml.XMLConfiguration;

class TableQueryResultsHandlerConverter
extends AbstractConverter {
    private static final String TABLE_QUERY_RESULTS_HANDLER = "tableQueryResultsHandler";
    public static URL querySchemaUrl = null;
    private static final String TABLE_COLUMN_SPECS = "tableColumnSpecs";
    private final TableColumnSpecsConverter columnSpecsConverter = new TableColumnSpecsConverter(this.getKnowledgeSource());

    TableQueryResultsHandlerConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class clazz) {
        return TableDestination.class.equals((Object)clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (!XMLConfiguration.isSurpressSchemaReferenceRequested()) {
            writer.addAttribute("xsi:noNamespaceSchemaLocation", this.getTableQueryResultsHandlerUrl().toExternalForm());
        }
        TableDestination resultsHandler = (TableDestination)value;
        writer.addAttribute("columnDelimiter", Character.toString(resultsHandler.getColumnDelimiter()));
        String[] propIDs = resultsHandler.getRowPropositionIds();
        PropIDsConverter propIDsConverter = new PropIDsConverter(this.getKnowledgeSource());
        writer.startNode("rowPropositionIDs");
        context.convertAnother((Object)propIDs, (Converter)propIDsConverter);
        writer.endNode();
        TableColumnSpec[] tableColumnSpecs = resultsHandler.getColumnSpecs();
        writer.startNode(TABLE_COLUMN_SPECS);
        context.convertAnother((Object)tableColumnSpecs, (Converter)this.columnSpecsConverter);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (!TABLE_QUERY_RESULTS_HANDLER.equals(reader.getNodeName())) {
            String msg = "Current element tag is " + reader.getNodeName() + " but expected " + TABLE_QUERY_RESULTS_HANDLER;
            throw new ConversionException(msg);
        }
        String columnDelimiter = this.requiredAttributeValue(reader, "columnDelimiter");
        this.expectChildren(reader);
        reader.moveDown();
        this.expect(reader, "rowPropositionIDs");
        PropIDsConverter propIDsConverter = new PropIDsConverter(this.getKnowledgeSource());
        String[] propIds = (String[])context.convertAnother(null, String[].class, (Converter)propIDsConverter);
        reader.moveUp();
        reader.moveDown();
        this.expect(reader, TABLE_COLUMN_SPECS);
        TableColumnSpec[] tableColumnSpecs = (TableColumnSpec[])context.convertAnother(null, TableColumnSpec[].class, (Converter)this.columnSpecsConverter);
        reader.moveUp();
        this.expectNoMore(reader);
        BufferedWriter dataWriter = (BufferedWriter)context.get((Object)"writer");
        return new TableDestination(dataWriter, columnDelimiter.charAt(0), propIds, tableColumnSpecs, true);
    }

    URL getTableQueryResultsHandlerUrl() {
        return TableQueryResultsHandlerConverter.getUrl("tableQueryResultsHandler.url");
    }
}

