/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.mvel.ConversionException;
import org.protempa.proposition.value.ValueComparator;

class ValueComparatorValueConverter
implements SingleValueConverter {
    private static final String GT = "greater";
    private static final String LT = "less";
    private static final String EQ = "equal";
    private static final String NE = "notEqual";
    private static final String GTE = "greaterOrEqual";
    private static final String LTE = "lessOrEqual";
    private static final String IN = "in";
    private static final String NIN = "notIn";

    ValueComparatorValueConverter() {
    }

    public boolean canConvert(Class clazz) {
        return ValueComparator.class.isAssignableFrom(clazz);
    }

    public Object fromString(String s) {
        switch (s) {
            case "greater": {
                return ValueComparator.GREATER_THAN;
            }
            case "less": {
                return ValueComparator.LESS_THAN;
            }
            case "equal": {
                return ValueComparator.EQUAL_TO;
            }
            case "notEqual": {
                return ValueComparator.NOT_EQUAL_TO;
            }
            case "greaterOrEqual": {
                return ValueComparator.GREATER_THAN_OR_EQUAL_TO;
            }
            case "lessOrEqual": {
                return ValueComparator.LESS_THAN_OR_EQUAL_TO;
            }
            case "in": {
                return ValueComparator.IN;
            }
            case "notIn": {
                return ValueComparator.NOT_IN;
            }
        }
        throw new ConversionException("Unrecognized comparator value: " + s);
    }

    public String toString(Object obj) {
        if (obj == ValueComparator.GREATER_THAN) {
            return GT;
        }
        if (obj == ValueComparator.LESS_THAN) {
            return LT;
        }
        if (obj == ValueComparator.EQUAL_TO) {
            return EQ;
        }
        if (obj == ValueComparator.NOT_EQUAL_TO) {
            return NE;
        }
        if (obj == ValueComparator.GREATER_THAN_OR_EQUAL_TO) {
            return GTE;
        }
        if (obj == ValueComparator.LESS_THAN_OR_EQUAL_TO) {
            return LTE;
        }
        if (obj == ValueComparator.IN) {
            return IN;
        }
        if (obj == ValueComparator.NOT_IN) {
            return NIN;
        }
        throw new ConversionException("Encountered ValueComparator object with no known string representation: " + obj);
    }
}

