/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.ValueOutputConfig;
import org.protempa.xml.AbstractConverter;

class ValueOutputConfigConverter
extends AbstractConverter {
    private static final String PROPERTY_VALUE_ABBREV_DISPLAY_NAME = "propertyValueAbbrevDisplayName";
    private static final String PROPERTY_VALUE_DISPLAY_NAME = "propertyValueDisplayName";
    private static final String SHOW_PROPERTY_VALUE_ABBREV_DISPLAY_NAME = "showPropertyValueAbbrevDisplayName";
    private static final String SHOW_PROPERTY_VALUE_DISPLAY_NAME = "showPropertyValueDisplayName";

    ValueOutputConfigConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return ValueOutputConfig.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ValueOutputConfig valueOutputConfig = (ValueOutputConfig)source;
        writer.addAttribute(SHOW_PROPERTY_VALUE_DISPLAY_NAME, Boolean.toString(valueOutputConfig.isShowPropertyValueDisplayName()));
        writer.addAttribute(SHOW_PROPERTY_VALUE_ABBREV_DISPLAY_NAME, Boolean.toString(valueOutputConfig.isShowPropertyValueAbbrevDisplayName()));
        writer.addAttribute(PROPERTY_VALUE_DISPLAY_NAME, valueOutputConfig.getPropertyValueDisplayName());
        writer.addAttribute(PROPERTY_VALUE_ABBREV_DISPLAY_NAME, valueOutputConfig.getPropertyValueAbbrevDisplayName());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        boolean showPropertyValueDisplayName = Boolean.valueOf(reader.getAttribute(SHOW_PROPERTY_VALUE_DISPLAY_NAME));
        boolean showPropertyValueAbbrevDisplayName = Boolean.valueOf(reader.getAttribute(SHOW_PROPERTY_VALUE_ABBREV_DISPLAY_NAME));
        String propertyValueDisplayName = ValueOutputConfigConverter.nullAsEmptyString(reader.getAttribute(PROPERTY_VALUE_DISPLAY_NAME));
        String propertyValueAbbrevDisplayName = ValueOutputConfigConverter.nullAsEmptyString(reader.getAttribute(PROPERTY_VALUE_ABBREV_DISPLAY_NAME));
        return new ValueOutputConfig(showPropertyValueDisplayName, showPropertyValueAbbrevDisplayName, propertyValueDisplayName, propertyValueAbbrevDisplayName);
    }
}

