/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protempa.AbstractSource;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.KnowledgeSourceUpdatedEvent;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.SourceCloseException;
import org.protempa.SourceClosedUnexpectedlyEvent;
import org.protempa.SourceListener;
import org.protempa.SubtreePropositionDefinitionGetterForWrapper;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.TermSubsumption;
import org.protempa.backend.Backend;
import org.protempa.backend.KnowledgeSourceBackendUpdatedEvent;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.query.And;
import org.protempa.valueset.ValueSet;

class KnowledgeSourceImplWrapper
extends AbstractSource<KnowledgeSourceUpdatedEvent, KnowledgeSourceBackend, KnowledgeSourceUpdatedEvent, KnowledgeSourceBackendUpdatedEvent>
implements KnowledgeSource {
    private final KnowledgeSource knowledgeSource;
    private final Map<String, AbstractionDefinition> abstractionDefinitionsMap;
    private final Map<String, PropositionDefinition> propositionDefinitionsMap;
    private final Map<String, TemporalPropositionDefinition> temporalPropDefsMap;
    private final Map<String, ContextDefinition> contextDefinitionsMap;
    private final Map<String, List<String>> isAMap;
    private final Map<String, List<String>> abstractedIntoMap;
    private final Map<String, List<String>> inducesMap;
    private final Map<String, List<String>> subContextOfMap;
    private final Map<String, List<String>> termIdMap;
    private SubtreePropositionDefinitionGetterForWrapper inDataSourceGetter;
    private boolean initialized;
    private SubtreePropositionDefinitionGetterForWrapper collectSubtreeGetter;

    KnowledgeSourceImplWrapper(KnowledgeSource knowledgeSource, PropositionDefinition ... propositionDefinitions) {
        super((Backend[])new KnowledgeSourceBackend[0]);
        assert (knowledgeSource != null) : "knowledgeSource cannot be null";
        this.knowledgeSource = knowledgeSource;
        this.propositionDefinitionsMap = new HashMap<String, PropositionDefinition>();
        this.abstractionDefinitionsMap = new HashMap<String, AbstractionDefinition>();
        this.contextDefinitionsMap = new HashMap<String, ContextDefinition>();
        this.temporalPropDefsMap = new HashMap<String, TemporalPropositionDefinition>();
        this.isAMap = new HashMap<String, List<String>>();
        this.abstractedIntoMap = new HashMap<String, List<String>>();
        this.inducesMap = new HashMap<String, List<String>>();
        this.subContextOfMap = new HashMap<String, List<String>>();
        this.termIdMap = new HashMap<String, List<String>>();
        for (PropositionDefinition propDef : propositionDefinitions) {
            String propId = propDef.getId();
            if (propDef instanceof ContextDefinition) {
                ContextDefinition cd = (ContextDefinition)propDef;
                for (TemporalExtendedPropositionDefinition inducedBy : cd.getInducedBy()) {
                    org.arp.javautil.collections.Collections.putList(this.inducesMap, (Object)inducedBy.getPropositionId(), (Object)propId);
                }
                Object[] objectArray = cd.getSubContexts();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object subContextId = objectArray[i];
                    org.arp.javautil.collections.Collections.putList(this.subContextOfMap, (Object)subContextId, (Object)propId);
                }
                this.contextDefinitionsMap.put(propId, cd);
            } else {
                if (propDef instanceof AbstractionDefinition) {
                    AbstractionDefinition ad = (AbstractionDefinition)propDef;
                    for (String abstractedFromPropId : ad.getAbstractedFrom()) {
                        org.arp.javautil.collections.Collections.putList(this.abstractedIntoMap, (Object)abstractedFromPropId, (Object)propId);
                    }
                    this.abstractionDefinitionsMap.put(propId, ad);
                }
                if (propDef instanceof TemporalPropositionDefinition) {
                    this.temporalPropDefsMap.put(propId, (TemporalPropositionDefinition)propDef);
                }
            }
            this.propositionDefinitionsMap.put(propId, propDef);
            for (String inverseIsAPropId : propDef.getInverseIsA()) {
                org.arp.javautil.collections.Collections.putList(this.isAMap, (Object)inverseIsAPropId, (Object)propId);
            }
            for (String termId : propDef.getTermIds()) {
                org.arp.javautil.collections.Collections.putList(this.termIdMap, (Object)termId, (Object)propId);
            }
        }
        this.knowledgeSource.addSourceListener(new SourceListener<KnowledgeSourceUpdatedEvent>(){

            @Override
            public void sourceUpdated(KnowledgeSourceUpdatedEvent e) {
                KnowledgeSourceImplWrapper.this.fireSourceUpdated(e);
            }

            @Override
            public void closedUnexpectedly(SourceClosedUnexpectedlyEvent e) {
                KnowledgeSourceImplWrapper.this.fireClosedUnexpectedly(e);
            }
        });
    }

    private void initializeIfNeeded() {
        if (!this.initialized) {
            this.inDataSourceGetter = new SubtreePropositionDefinitionGetterForWrapper(this.propositionDefinitionsMap, this.knowledgeSource, true);
            this.collectSubtreeGetter = new SubtreePropositionDefinitionGetterForWrapper(this.propositionDefinitionsMap, this.knowledgeSource, false);
            this.initialized = true;
        }
    }

    @Override
    public List<String> getPropositionDefinitionsByTerm(And<TermSubsumption> termSubsumptionClause) throws KnowledgeSourceReadException {
        if (termSubsumptionClause == null) {
            throw new IllegalArgumentException("termSubsumptionClause cannot be null");
        }
        this.initializeIfNeeded();
        ArrayList propIdSets = new ArrayList();
        for (TermSubsumption ts : termSubsumptionClause.getAnded()) {
            HashSet<String> subsumpPropIds = new HashSet<String>();
            for (String termId : ts.getTerms()) {
                List<String> propIds = this.termIdMap.get(termId);
                if (propIds == null) continue;
                subsumpPropIds.addAll(propIds);
            }
            propIdSets.add(subsumpPropIds);
        }
        Set matchingPropIds = org.arp.javautil.collections.Collections.intersection(propIdSets);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(matchingPropIds);
        List<String> resultFromKS = this.knowledgeSource.getPropositionDefinitionsByTerm(termSubsumptionClause);
        for (String propId : resultFromKS) {
            if (this.propositionDefinitionsMap.containsKey(propId)) continue;
            result.add(propId);
        }
        return result;
    }

    @Override
    public boolean hasAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        boolean result = this.abstractionDefinitionsMap.containsKey(id);
        if (!result) {
            result = this.knowledgeSource.hasAbstractionDefinition(id);
        }
        return result;
    }

    @Override
    public boolean hasPropositionDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        boolean result = this.propositionDefinitionsMap.containsKey(id);
        if (!result) {
            result = this.knowledgeSource.hasPropositionDefinition(id);
        }
        return result;
    }

    @Override
    public boolean hasContextDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        boolean result = this.contextDefinitionsMap.containsKey(id);
        if (!result) {
            result = this.knowledgeSource.hasContextDefinition(id);
        }
        return result;
    }

    @Override
    public boolean hasTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        boolean result = this.temporalPropDefsMap.containsKey(id);
        if (!result) {
            result = this.knowledgeSource.hasTemporalPropositionDefinition(id);
        }
        return result;
    }

    @Override
    public boolean hasValueSet(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        return this.knowledgeSource.hasValueSet(id);
    }

    @Override
    public Set<PropositionDefinition> collectPropDefDescendantsUsingAllNarrower(boolean inDataSourceOnly, String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded();
        return this.inDataSourceGetter.collectPropDefs(inDataSourceOnly, propIds);
    }

    @Override
    public Set<String> collectPropIdDescendantsUsingAllNarrower(boolean inDataSourceOnly, String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded();
        return this.inDataSourceGetter.collectPropIds(inDataSourceOnly, propIds);
    }

    @Override
    public Set<PropositionDefinition> collectPropDefDescendantsUsingInverseIsA(String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded();
        return this.collectSubtreeGetter.collectPropDefs(false, propIds);
    }

    @Override
    public Set<String> collectPropIdDescendantsUsingInverseIsA(String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded();
        return this.collectSubtreeGetter.collectPropIds(false, propIds);
    }

    @Override
    public List<TemporalPropositionDefinition> readInducedBy(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        ContextDefinition def = this.readContextDefinition(id);
        if (def != null) {
            return this.readInducedBy(this.readContextDefinition(id));
        }
        return Collections.emptyList();
    }

    @Override
    public List<TemporalPropositionDefinition> readInducedBy(ContextDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        ArrayList<TemporalPropositionDefinition> result = new ArrayList<TemporalPropositionDefinition>();
        for (TemporalExtendedPropositionDefinition tepd : propDef.getInducedBy()) {
            result.add(this.readTemporalPropositionDefinition(tepd.getPropositionId()));
        }
        return result;
    }

    @Override
    public List<ContextDefinition> readSubContexts(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        ContextDefinition def = this.readContextDefinition(id);
        if (def != null) {
            return this.readSubContexts(this.readContextDefinition(id));
        }
        return Collections.emptyList();
    }

    @Override
    public List<ContextDefinition> readSubContexts(ContextDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        for (String subContextId : propDef.getSubContexts()) {
            ContextDefinition contextDefinition = this.readContextDefinition(subContextId);
            if (contextDefinition == null) {
                throw new AssertionError((Object)("Context definition " + propDef.getId() + " is invalid because sub-context " + subContextId + " does not exist."));
            }
            result.add(contextDefinition);
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> readAbstractedFrom(AbstractionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        for (String propId : propDef.getAbstractedFrom()) {
            result.add(this.readPropositionDefinition(propId));
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> readAbstractedFrom(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        AbstractionDefinition def = this.readAbstractionDefinition(id);
        if (def != null) {
            return this.readAbstractedFrom(this.readAbstractionDefinition(id));
        }
        return Collections.emptyList();
    }

    @Override
    public List<AbstractionDefinition> readAbstractedInto(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        List<String> propIds;
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        String propId = propDef.getId();
        ArrayList<AbstractionDefinition> result = new ArrayList<AbstractionDefinition>();
        if (this.abstractedIntoMap.containsKey(propId) && (propIds = this.abstractedIntoMap.get(propDef.getId())) != null) {
            for (String abstractedIntoPropId : propIds) {
                result.add(this.readAbstractionDefinition(abstractedIntoPropId));
            }
        }
        List<AbstractionDefinition> r = this.knowledgeSource.readAbstractedInto(propDef);
        for (AbstractionDefinition def : r) {
            if (this.propositionDefinitionsMap.containsKey(def.getId())) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public List<AbstractionDefinition> readAbstractedInto(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        this.initializeIfNeeded();
        PropositionDefinition propDef = this.readPropositionDefinition(propId);
        if (propDef != null) {
            return this.readAbstractedInto(propDef);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ContextDefinition> readInduces(TemporalPropositionDefinition propDef) throws KnowledgeSourceReadException {
        List<String> propIds;
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        String propId = propDef.getId();
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        if (this.inducesMap.containsKey(propId) && (propIds = this.inducesMap.get(propDef.getId())) != null) {
            for (String inducesPropId : propIds) {
                result.add(this.readContextDefinition(inducesPropId));
            }
        }
        List<ContextDefinition> r = this.knowledgeSource.readInduces(propDef);
        for (ContextDefinition def : r) {
            if (this.propositionDefinitionsMap.containsKey(def.getId())) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public List<ContextDefinition> readInduces(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        this.initializeIfNeeded();
        TemporalPropositionDefinition propDef = this.readTemporalPropositionDefinition(propId);
        if (propDef != null) {
            return this.readInduces(propDef);
        }
        return Collections.emptyList();
    }

    @Override
    public AbstractionDefinition readAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        AbstractionDefinition result = this.abstractionDefinitionsMap.get(id);
        if (result == null) {
            result = this.knowledgeSource.readAbstractionDefinition(id);
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> readInverseIsA(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        for (String propId : propDef.getInverseIsA()) {
            result.add(this.readPropositionDefinition(propId));
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> readInverseIsA(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        PropositionDefinition def = this.readPropositionDefinition(id);
        if (def != null) {
            return this.readInverseIsA(def);
        }
        return Collections.emptyList();
    }

    @Override
    public List<PropositionDefinition> readIsA(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        List<String> propIds;
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        String propId = propDef.getId();
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        if (this.isAMap.containsKey(propId) && (propIds = this.isAMap.get(propDef.getId())) != null) {
            for (String isAPropId : propIds) {
                result.add(this.readPropositionDefinition(isAPropId));
            }
        }
        List<PropositionDefinition> r = this.knowledgeSource.readIsA(propDef);
        for (PropositionDefinition def : r) {
            if (this.propositionDefinitionsMap.containsKey(def.getId())) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> readIsA(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        this.initializeIfNeeded();
        PropositionDefinition propDef = this.readPropositionDefinition(propId);
        if (propDef != null) {
            return this.readIsA(propDef);
        }
        return Collections.emptyList();
    }

    @Override
    public PropositionDefinition readPropositionDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        PropositionDefinition result = this.propositionDefinitionsMap.get(id);
        if (result == null) {
            result = this.knowledgeSource.readPropositionDefinition(id);
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> readPropositionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        this.initializeIfNeeded();
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        ArrayList<String> propIdsToGet = new ArrayList<String>();
        for (String id : propIds) {
            PropositionDefinition propDef = this.propositionDefinitionsMap.get(id);
            if (propDef != null) {
                result.add(propDef);
                continue;
            }
            propIdsToGet.add(id);
        }
        result.addAll(this.knowledgeSource.readPropositionDefinitions(propIdsToGet.toArray(new String[propIdsToGet.size()])));
        return result;
    }

    @Override
    public List<AbstractionDefinition> readAbstractionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        this.initializeIfNeeded();
        ArrayList<AbstractionDefinition> result = new ArrayList<AbstractionDefinition>();
        ArrayList<String> propIdsToGet = new ArrayList<String>();
        for (String id : propIds) {
            AbstractionDefinition propDef = this.abstractionDefinitionsMap.get(id);
            if (propDef != null) {
                result.add(propDef);
                continue;
            }
            propIdsToGet.add(id);
        }
        result.addAll(this.knowledgeSource.readAbstractionDefinitions(propIdsToGet.toArray(new String[propIdsToGet.size()])));
        return result;
    }

    @Override
    public List<TemporalPropositionDefinition> readTemporalPropositionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        this.initializeIfNeeded();
        ArrayList<TemporalPropositionDefinition> result = new ArrayList<TemporalPropositionDefinition>();
        ArrayList<String> propIdsToGet = new ArrayList<String>();
        for (String id : propIds) {
            TemporalPropositionDefinition propDef = this.temporalPropDefsMap.get(id);
            if (propDef != null) {
                result.add(propDef);
                continue;
            }
            propIdsToGet.add(id);
        }
        result.addAll(this.knowledgeSource.readTemporalPropositionDefinitions(propIdsToGet.toArray(new String[propIdsToGet.size()])));
        return result;
    }

    @Override
    public List<ContextDefinition> readContextDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        this.initializeIfNeeded();
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        ArrayList<String> propIdsToGet = new ArrayList<String>();
        for (String id : propIds) {
            ContextDefinition propDef = this.contextDefinitionsMap.get(id);
            if (propDef != null) {
                result.add(propDef);
                continue;
            }
            propIdsToGet.add(id);
        }
        result.addAll(this.knowledgeSource.readContextDefinitions(propIdsToGet.toArray(new String[propIdsToGet.size()])));
        return result;
    }

    PropositionDefinition readPropositionDefinitionInt(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        PropositionDefinition result = this.propositionDefinitionsMap.get(id);
        return result;
    }

    @Override
    public TemporalPropositionDefinition readTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        TemporalPropositionDefinition result = this.temporalPropDefsMap.get(id);
        if (result == null) {
            result = this.knowledgeSource.readTemporalPropositionDefinition(id);
        }
        return result;
    }

    @Override
    public ContextDefinition readContextDefinition(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        ContextDefinition result = this.contextDefinitionsMap.get(id);
        if (result == null) {
            result = this.knowledgeSource.readContextDefinition(id);
        }
        return result;
    }

    @Override
    public ValueSet readValueSet(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.initializeIfNeeded();
        return this.knowledgeSource.readValueSet(id);
    }

    @Override
    public List<PropositionDefinition> readParents(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        String propId = propDef.getId();
        if (this.propositionDefinitionsMap.containsKey(propId)) {
            ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
            result.addAll(this.readIsA(propDef));
            result.addAll(this.readAbstractedInto(propDef));
            return result;
        }
        return this.knowledgeSource.readParents(propDef);
    }

    @Override
    public List<PropositionDefinition> readParents(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        this.initializeIfNeeded();
        PropositionDefinition propDef = this.readPropositionDefinition(propId);
        if (propDef != null) {
            return this.readParents(propDef);
        }
        return Collections.emptyList();
    }

    @Override
    public void close() throws SourceCloseException {
        if (this.initialized) {
            this.inDataSourceGetter.clear();
        }
        this.knowledgeSource.close();
    }

    @Override
    public void clear() {
        if (this.initialized) {
            this.inDataSourceGetter.clear();
        }
        this.knowledgeSource.clear();
    }

    @Override
    public void backendUpdated(KnowledgeSourceBackendUpdatedEvent evt) {
    }

    @Override
    public List<ContextDefinition> readSubContextOfs(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        ContextDefinition def = this.readContextDefinition(id);
        if (def != null) {
            return this.readSubContextOfs(this.readContextDefinition(id));
        }
        return Collections.emptyList();
    }

    @Override
    public List<ContextDefinition> readSubContextOfs(ContextDefinition contextDef) throws KnowledgeSourceReadException {
        List<String> propIds;
        if (contextDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        this.initializeIfNeeded();
        String propId = contextDef.getId();
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        if (this.subContextOfMap.containsKey(propId) && (propIds = this.subContextOfMap.get(contextDef.getId())) != null) {
            for (String subContextOfId : propIds) {
                result.add(this.readContextDefinition(subContextOfId));
            }
        }
        List<ContextDefinition> r = this.knowledgeSource.readSubContextOfs(contextDef);
        for (ContextDefinition def : r) {
            if (this.propositionDefinitionsMap.containsKey(def.getId())) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public List<PropositionDefinition> getMatchingPropositionDefinitions(String searchKey) throws KnowledgeSourceReadException {
        return null;
    }
}

