/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.xml;

import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.ProtempaEventListener;
import org.protempa.dest.AbstractDestination;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.xml.XmlQueryResultsHandler;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

public final class XmlDestination
extends AbstractDestination {
    private final String[] propIds;
    private final String initialPropId;
    private final Map<String, String> propOrder;
    private final Writer writer;

    public XmlDestination(Writer writer, Map<String, String> propOrder, String initialPropId, String[] propIds) {
        this.writer = writer;
        this.propOrder = propOrder;
        this.initialPropId = initialPropId;
        this.propIds = propIds == null ? new String[0] : (String[])propIds.clone();
    }

    @Override
    public QueryResultsHandler getQueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource, List<? extends ProtempaEventListener> eventListeners) throws QueryResultsHandlerInitException {
        if (query.getQueryMode() == QueryMode.UPDATE) {
            throw new QueryResultsHandlerInitException("Update mode not supported");
        }
        return new XmlQueryResultsHandler(this.writer, this.propOrder, this.initialPropId, this.propIds, knowledgeSource);
    }

    @Override
    public String[] getSupportedPropositionIds(DataSource dataSource, KnowledgeSource knowledgeSource) {
        HashSet<String> result = new HashSet<String>();
        result.add(this.initialPropId);
        Arrays.addAll(result, (Object[][])new String[][]{this.propIds});
        return result.toArray(new String[result.size()]);
    }
}

