/*
 * #%L
 * Protempa Framework
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.protempa.dest;

import java.util.Collection;
import org.protempa.PropositionDefinition;

/**
 *
 * @author Andrew Post
 */
public abstract class AbstractQueryResultsHandler
        implements QueryResultsHandler {
    
    private String id;
    
    protected AbstractQueryResultsHandler() {
        this.id = getClass().getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    /**
     * Returns this query result handler's display name for user interfaces. 
     * This implementation returns the same string as {@link #getId() }.
     * 
     * @return a string.
     */
    @Override
    public String getDisplayName() {
        return getId();
    }

    @Override
    public void validate() throws QueryResultsHandlerValidationFailedException {
    }

    @Override
    public void start(Collection<PropositionDefinition> cache) throws QueryResultsHandlerProcessingException {
    }

    @Override
    public void finish() throws QueryResultsHandlerProcessingException {
    }

    @Override
    public void close() throws QueryResultsHandlerCloseException {
    }

    @Override
    public void cancel() {
    }
    
}
