/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.spi.ConflictResolver;
import org.protempa.AbstractPropositionDefinitionCheckedVisitor;
import org.protempa.Algorithm;
import org.protempa.AlgorithmSource;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.ConstantDefinition;
import org.protempa.ContextDefinition;
import org.protempa.CreateRuleBaseException;
import org.protempa.CycleDetectedException;
import org.protempa.DerivationsBuilder;
import org.protempa.EventDefinition;
import org.protempa.ExecutionStrategy;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.JBossRuleBaseFactory;
import org.protempa.JBossRuleCreator;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.NoSuchAlgorithmException;
import org.protempa.PROTEMPAConflictResolver;
import org.protempa.PrimitiveParameterDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaException;
import org.protempa.RuleBaseInstantiationException;
import org.protempa.SequentialTemporalPatternDefinition;
import org.protempa.SliceDefinition;

abstract class AbstractExecutionStrategy
implements ExecutionStrategy {
    private final AlgorithmSource algorithmSource;
    protected RuleBase ruleBase;

    AbstractExecutionStrategy(AlgorithmSource algorithmSource) {
        this.algorithmSource = algorithmSource;
    }

    protected final AlgorithmSource getAlgorithmSource() {
        return this.algorithmSource;
    }

    @Override
    public void createRuleBase(Collection<PropositionDefinition> allNarrowerDescendants, DerivationsBuilder listener) throws CreateRuleBaseException {
        ValidateAlgorithmCheckedVisitor visitor = new ValidateAlgorithmCheckedVisitor(this.algorithmSource);
        JBossRuleCreator ruleCreator = new JBossRuleCreator(visitor.getAlgorithms(), listener, allNarrowerDescendants);
        if (allNarrowerDescendants != null) {
            try {
                for (PropositionDefinition pd : allNarrowerDescendants) {
                    pd.acceptChecked(visitor);
                }
                ruleCreator.visit(allNarrowerDescendants);
            }
            catch (ProtempaException ex) {
                throw new CreateRuleBaseException(ex);
            }
        }
        try {
            this.ruleBase = new JBossRuleBaseFactory(ruleCreator, this.createRuleBaseConfiguration(ruleCreator, allNarrowerDescendants)).newInstance();
        }
        catch (RuleBaseInstantiationException ex) {
            throw new CreateRuleBaseException(ex);
        }
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    protected RuleBaseConfiguration createRuleBaseConfiguration(JBossRuleCreator ruleCreator, Collection<PropositionDefinition> allNarrowerDescendants) throws RuleBaseInstantiationException {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setShadowProxy(false);
        try {
            config.setConflictResolver((ConflictResolver)new PROTEMPAConflictResolver(allNarrowerDescendants, ruleCreator.getRuleToTPDMap()));
        }
        catch (CycleDetectedException ex) {
            throw new RuleBaseInstantiationException("Problem creating data processing rules", ex);
        }
        config.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        return config;
    }

    private class ValidateAlgorithmCheckedVisitor
    extends AbstractPropositionDefinitionCheckedVisitor {
        private final Map<LowLevelAbstractionDefinition, Algorithm> algorithms = new HashMap<LowLevelAbstractionDefinition, Algorithm>();
        private final AlgorithmSource algorithmSource;

        ValidateAlgorithmCheckedVisitor(AlgorithmSource algorithmSource) {
            this.algorithmSource = algorithmSource;
        }

        Map<LowLevelAbstractionDefinition, Algorithm> getAlgorithms() {
            return this.algorithms;
        }

        @Override
        public void visit(LowLevelAbstractionDefinition lowLevelAbstractionDefinition) throws ProtempaException {
            String algorithmId = lowLevelAbstractionDefinition.getAlgorithmId();
            Algorithm algorithm = this.algorithmSource.readAlgorithm(algorithmId);
            if (algorithm == null && algorithmId != null) {
                throw new NoSuchAlgorithmException("Low level abstraction definition " + lowLevelAbstractionDefinition.getId() + " wants the algorithm " + algorithmId + ", but no such algorithm is available.");
            }
            this.algorithms.put(lowLevelAbstractionDefinition, algorithm);
        }

        @Override
        public void visit(CompoundLowLevelAbstractionDefinition extendedLowLevelAbstractionDefinition) throws ProtempaException {
        }

        @Override
        public void visit(EventDefinition eventDefinition) throws ProtempaException {
        }

        @Override
        public void visit(HighLevelAbstractionDefinition highLevelAbstractionDefinition) throws ProtempaException {
        }

        @Override
        public void visit(PrimitiveParameterDefinition primitiveParameterDefinition) throws ProtempaException {
        }

        @Override
        public void visit(SliceDefinition sliceAbstractionDefinition) throws ProtempaException {
        }

        @Override
        public void visit(SequentialTemporalPatternDefinition pairAbstractionDefinition) throws ProtempaException {
        }

        @Override
        public void visit(ConstantDefinition def) throws ProtempaException {
        }

        @Override
        public void visit(ContextDefinition def) throws ProtempaException {
        }
    }
}

