/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.protempa.JBossRuleCreator;
import org.protempa.RuleBaseInstantiationException;
import org.protempa.WorkingMemoryGlobals;

class JBossRuleBaseFactory {
    private final JBossRuleCreator ruleCreator;
    private final RuleBaseConfiguration ruleBaseConfiguration;

    JBossRuleBaseFactory(JBossRuleCreator ruleCreator, RuleBaseConfiguration ruleBaseConfiguration) {
        assert (ruleCreator != null) : "ruleCreator cannot be null";
        this.ruleCreator = ruleCreator;
        this.ruleBaseConfiguration = ruleBaseConfiguration;
    }

    RuleBase newInstance() throws RuleBaseInstantiationException {
        return JBossRuleBaseFactory.newRuleBase(this.ruleBaseConfiguration, this.newPackage());
    }

    private Package newPackage() {
        Package rules = new Package("PROTEMPA Rules");
        for (Rule rule : this.ruleCreator.getRules()) {
            rules.addRule(rule);
        }
        return rules;
    }

    private static RuleBase newRuleBase(RuleBaseConfiguration config, Package rules) throws RuleBaseInstantiationException {
        WorkingMemoryGlobals.addAll(rules);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)config);
        try {
            ruleBase.addPackage(rules);
        }
        catch (Exception e) {
            throw new RuleBaseInstantiationException("Could not instantiate proposition definitions", e);
        }
        return ruleBase;
    }
}

