/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.AbstractSource;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.InvalidPropositionIdException;
import org.protempa.InvalidValueSetDefinitionException;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.KnowledgeSourceUpdatedEvent;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.ProtempaUtil;
import org.protempa.SourceCloseException;
import org.protempa.SubtreePropositionDefinitionGetterRegular;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.TermSubsumption;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendNewInstanceException;
import org.protempa.backend.KnowledgeSourceBackendUpdatedEvent;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.query.And;
import org.protempa.valueset.ValueSet;

public final class KnowledgeSourceImpl
extends AbstractSource<KnowledgeSourceUpdatedEvent, KnowledgeSourceBackend, KnowledgeSourceUpdatedEvent, KnowledgeSourceBackendUpdatedEvent>
implements KnowledgeSource {
    private PropositionDefinitionCache propositionDefinitionCache;
    private final Map<String, Object> notFoundAbstractionDefinitionRequests;
    private final Map<String, Object> notFoundValueSetRequests;
    private final Map<String, Object> notFoundContextDefinitionRequests;
    private final Map<String, Object> notFoundPropositionDefinitionRequests;
    private final Map<String, Object> notFoundTemporalPropositionDefinitionRequests;
    private final PropositionDefinitionReader propDefReader;
    private final AbstractionDefinitionReader abstractionDefReader;
    private final ContextDefinitionReader contextDefReader;
    private final TemporalPropositionDefinitionReader tempPropDefReader;
    private final Map<PropositionDefinition, List<PropositionDefinition>> inverseIsACache = new ReferenceMap();
    private final Map<AbstractionDefinition, List<PropositionDefinition>> abstractedFromCache = new ReferenceMap();
    private final Map<ContextDefinition, List<ContextDefinition>> subContextsCache = new ReferenceMap();
    private final Map<ContextDefinition, List<TemporalPropositionDefinition>> inducedByCache = new ReferenceMap();
    private SubtreePropositionDefinitionGetterRegular inDataSourceGetter;
    private SubtreePropositionDefinitionGetterRegular collectSubtreeGetter;

    public KnowledgeSourceImpl(KnowledgeSourceBackend ... backends) {
        super((Backend[])backends);
        this.notFoundAbstractionDefinitionRequests = new WeakHashMap<String, Object>();
        this.notFoundValueSetRequests = new WeakHashMap<String, Object>();
        this.notFoundPropositionDefinitionRequests = new WeakHashMap<String, Object>();
        this.notFoundContextDefinitionRequests = new WeakHashMap<String, Object>();
        this.notFoundTemporalPropositionDefinitionRequests = new HashMap<String, Object>();
        this.propDefReader = new PropositionDefinitionReader();
        this.abstractionDefReader = new AbstractionDefinitionReader();
        this.contextDefReader = new ContextDefinitionReader();
        this.tempPropDefReader = new TemporalPropositionDefinitionReader();
    }

    private void initializeIfNeeded() throws BackendInitializationException, BackendNewInstanceException {
        if (this.isClosed()) {
            throw new IllegalStateException("Knowledge source already closed!");
        }
        if (this.propositionDefinitionCache == null) {
            this.propositionDefinitionCache = new PropositionDefinitionCache();
        }
        if (this.inDataSourceGetter == null) {
            this.inDataSourceGetter = new SubtreePropositionDefinitionGetterRegular(this, true);
        }
        if (this.collectSubtreeGetter == null) {
            this.collectSubtreeGetter = new SubtreePropositionDefinitionGetterRegular(this, false);
        }
    }

    private void initializeIfNeeded(String template, String ... propIds) throws KnowledgeSourceReadException {
        try {
            this.initializeIfNeeded();
        }
        catch (BackendInitializationException | BackendNewInstanceException ex) {
            String action = MessageFormat.format(template, StringUtils.join((Object[])propIds, (String)", "));
            throw new KnowledgeSourceReadException("An error occurred " + action, ex);
        }
    }

    private void initializeIfNeeded(String action) throws KnowledgeSourceReadException {
        this.initializeIfNeeded(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropositionDefinition> readInverseIsA(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        Map<PropositionDefinition, List<PropositionDefinition>> map = this.inverseIsACache;
        synchronized (map) {
            String[] propIds;
            List<PropositionDefinition> result = this.inverseIsACache.get(propDef);
            if (result != null) {
                return result;
            }
            result = new ArrayList<PropositionDefinition>();
            this.initializeIfNeeded("reading inverseIsA of {0}", propDef.getId());
            for (String propId : propIds = propDef.getInverseIsA()) {
                PropositionDefinition pd = this.readPropositionDefinition(propId);
                assert (pd != null) : "Proposition definition " + propId + ", which is specified as a child of " + propDef.getId() + ", does not exist";
                if (pd == null) continue;
                result.add(pd);
            }
            result = Collections.unmodifiableList(result);
            this.inverseIsACache.put(propDef, result);
            return result;
        }
    }

    @Override
    public List<PropositionDefinition> readIsA(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readIsA(propDef.getId());
    }

    @Override
    public List<String> readIsAPropIds(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readIsAPropIds(propDef.getId());
    }

    @Override
    public List<PropositionDefinition> readInverseIsA(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        PropositionDefinition propDef = this.readPropositionDefinition(id);
        if (propDef == null) {
            return Collections.emptyList();
        }
        return this.readInverseIsA(propDef);
    }

    @Override
    public List<PropositionDefinition> readIsA(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet isAs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(isAs, (Object[][])new String[][]{backend.readIsA(id)});
        }
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        for (String isAPropId : isAs) {
            result.add(this.readPropositionDefinition(isAPropId));
        }
        return result;
    }

    @Override
    public List<String> readIsAPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet isAs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(isAs, (Object[][])new String[][]{backend.readIsA(id)});
        }
        return new ArrayList<String>(isAs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropositionDefinition> readAbstractedFrom(AbstractionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        Map<AbstractionDefinition, List<PropositionDefinition>> map = this.abstractedFromCache;
        synchronized (map) {
            List<PropositionDefinition> result = this.abstractedFromCache.get(propDef);
            if (result != null) {
                return result;
            }
            result = new ArrayList<PropositionDefinition>();
            this.initializeIfNeeded("reading abstractedFrom of {0}", propDef.getId());
            Set<String> propIds = propDef.getAbstractedFrom();
            for (String propId : propIds) {
                PropositionDefinition pd = this.readPropositionDefinition(propId);
                assert (pd != null) : "Proposition definition " + propId + ", which " + propDef.getId() + "is specified as abstracted from, does not exist";
                if (pd == null) continue;
                result.add(pd);
            }
            result = Collections.unmodifiableList(result);
            if (propDef != null) {
                this.abstractedFromCache.put(propDef, result);
            }
            return result;
        }
    }

    @Override
    public List<AbstractionDefinition> readAbstractedInto(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readAbstractedInto(propDef.getId());
    }

    @Override
    public List<String> readAbstractedIntoPropIds(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readAbstractedIntoPropIds(propDef.getId());
    }

    @Override
    public List<PropositionDefinition> readAbstractedFrom(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        AbstractionDefinition propDef = this.readAbstractionDefinition(id);
        if (propDef == null) {
            return Collections.emptyList();
        }
        return this.readAbstractedFrom(propDef);
    }

    @Override
    public List<AbstractionDefinition> readAbstractedInto(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet abstractedIntos = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(abstractedIntos, (Object[][])new String[][]{backend.readAbstractedInto(id)});
        }
        ArrayList<AbstractionDefinition> result = new ArrayList<AbstractionDefinition>();
        for (String abstractedIntoPropId : abstractedIntos) {
            AbstractionDefinition def = this.readAbstractionDefinition(abstractedIntoPropId);
            if (def == null) {
                throw new KnowledgeSourceReadException("Invalid proposition id: " + abstractedIntoPropId);
            }
            result.add(def);
        }
        return result;
    }

    @Override
    public List<String> readAbstractedIntoPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet abstractedIntos = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(abstractedIntos, (Object[][])new String[][]{backend.readAbstractedInto(id)});
        }
        return new ArrayList<String>(abstractedIntos);
    }

    @Override
    public List<ContextDefinition> readInduces(TemporalPropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readInduces(propDef.getId());
    }

    @Override
    public List<String> readInducesPropIds(TemporalPropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        return this.readInducesPropIds(propDef.getId());
    }

    @Override
    public List<ContextDefinition> readInduces(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet induces = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(induces, (Object[][])new String[][]{backend.readInduces(id)});
        }
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        for (String inducesPropId : induces) {
            ContextDefinition def = this.readContextDefinition(inducesPropId);
            if (def == null) {
                throw new KnowledgeSourceReadException("Invalid proposition id: " + inducesPropId);
            }
            result.add(def);
        }
        return result;
    }

    @Override
    public List<String> readInducesPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet induces = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(induces, (Object[][])new String[][]{backend.readInduces(id)});
        }
        return new ArrayList<String>(induces);
    }

    @Override
    public List<ContextDefinition> readSubContextOfs(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet subContextOfs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(subContextOfs, (Object[][])new String[][]{backend.readSubContextOfs(id)});
        }
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        for (String subContextOfPropId : subContextOfs) {
            ContextDefinition def = this.readContextDefinition(subContextOfPropId);
            if (def == null) {
                throw new KnowledgeSourceReadException("Invalid context id: " + subContextOfPropId);
            }
            result.add(def);
        }
        return result;
    }

    @Override
    public List<String> readSubContextOfPropIds(String id) throws KnowledgeSourceReadException {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        HashSet subContextOfs = new HashSet();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            Arrays.addAll(subContextOfs, (Object[][])new String[][]{backend.readSubContextOfs(id)});
        }
        return new ArrayList<String>(subContextOfs);
    }

    @Override
    public List<ContextDefinition> readSubContextOfs(ContextDefinition cd) throws KnowledgeSourceReadException {
        if (cd == null) {
            throw new IllegalArgumentException("cd cannot be null");
        }
        return this.readSubContextOfs(cd.getId());
    }

    @Override
    public List<String> readSubContextOfPropIds(ContextDefinition cd) throws KnowledgeSourceReadException {
        if (cd == null) {
            throw new IllegalArgumentException("cd cannot be null");
        }
        return this.readSubContextOfPropIds(cd.getId());
    }

    @Override
    public List<ContextDefinition> readSubContexts(String contextId) throws KnowledgeSourceReadException {
        if (contextId == null) {
            throw new IllegalArgumentException("contextId cannot be null");
        }
        ContextDefinition pd = this.readContextDefinition(contextId);
        if (pd != null) {
            return this.readSubContexts(pd);
        }
        return new ArrayList<ContextDefinition>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContextDefinition> readSubContexts(ContextDefinition contextDef) throws KnowledgeSourceReadException {
        if (contextDef == null) {
            throw new IllegalArgumentException("contextDef cannot be null");
        }
        Map<ContextDefinition, List<ContextDefinition>> map = this.subContextsCache;
        synchronized (map) {
            String[] propIds;
            List<ContextDefinition> result = this.subContextsCache.get(contextDef);
            if (result != null) {
                return result;
            }
            result = new ArrayList<ContextDefinition>();
            this.initializeIfNeeded("reading subContexts of {0}", contextDef.getId());
            for (String propId : propIds = contextDef.getSubContexts()) {
                ContextDefinition pd = this.readContextDefinition(propId);
                assert (pd != null) : "Context definition " + propId + ", which " + contextDef.getId() + "is specified as abstracted from, does not exist";
                if (pd == null) continue;
                result.add(pd);
            }
            result = Collections.unmodifiableList(result);
            if (contextDef != null) {
                this.subContextsCache.put(contextDef, result);
            }
            return result;
        }
    }

    @Override
    public List<PropositionDefinition> readParents(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        List<String> result = this.readParentPropIds(propDef);
        return this.readPropositionDefinitions(result.toArray(new String[result.size()]));
    }

    @Override
    public List<String> readParentPropIds(PropositionDefinition propDef) throws KnowledgeSourceReadException {
        List<Object> induces;
        List<Object> subContextOfs;
        if (propDef == null) {
            throw new IllegalArgumentException("propDef cannot be null");
        }
        if (propDef instanceof ContextDefinition) {
            subContextOfs = this.readSubContextOfPropIds((ContextDefinition)propDef);
            induces = this.readInducesPropIds((ContextDefinition)propDef);
        } else {
            subContextOfs = Collections.emptyList();
            induces = Collections.emptyList();
        }
        List<String> ad = this.readAbstractedIntoPropIds(propDef);
        List<String> pd = this.readIsAPropIds(propDef);
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(subContextOfs);
        result.addAll(induces);
        result.addAll(ad);
        result.addAll(pd);
        return new ArrayList<String>(result);
    }

    @Override
    public List<PropositionDefinition> readParents(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        PropositionDefinition pd = this.readPropositionDefinition(propId);
        if (pd != null) {
            return this.readParents(pd);
        }
        return new ArrayList<PropositionDefinition>(0);
    }

    @Override
    public List<String> readParentPropIds(String propId) throws KnowledgeSourceReadException {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        PropositionDefinition pd = this.readPropositionDefinition(propId);
        if (pd != null) {
            return this.readParentPropIds(pd);
        }
        return new ArrayList<String>(0);
    }

    @Override
    public List<TemporalPropositionDefinition> readInducedBy(String contextId) throws KnowledgeSourceReadException {
        if (contextId == null) {
            throw new IllegalArgumentException("contextId cannot be null");
        }
        ContextDefinition pd = this.readContextDefinition(contextId);
        if (pd != null) {
            return this.readInducedBy(pd);
        }
        return new ArrayList<TemporalPropositionDefinition>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TemporalPropositionDefinition> readInducedBy(ContextDefinition contextDef) throws KnowledgeSourceReadException {
        if (contextDef == null) {
            throw new IllegalArgumentException("contextDef cannot be null");
        }
        Map<ContextDefinition, List<TemporalPropositionDefinition>> map = this.inducedByCache;
        synchronized (map) {
            TemporalExtendedPropositionDefinition[] propIds;
            List<TemporalPropositionDefinition> result = this.inducedByCache.get(contextDef);
            if (result != null) {
                return result;
            }
            result = new ArrayList<TemporalPropositionDefinition>();
            this.initializeIfNeeded("reading inducedBy of {0}", contextDef.getId());
            for (TemporalExtendedPropositionDefinition tepd : propIds = contextDef.getInducedBy()) {
                TemporalPropositionDefinition pd = this.readTemporalPropositionDefinition(tepd.getPropositionId());
                assert (pd != null) : "Proposition definition " + tepd.getPropositionId() + ", which " + contextDef.getId() + "is specified as induced by, does not exist";
                if (pd == null) continue;
                result.add(pd);
            }
            result = Collections.unmodifiableList(result);
            if (contextDef != null) {
                this.inducedByCache.put(contextDef, result);
            }
            return result;
        }
    }

    @Override
    public boolean hasTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.tempPropDefReader.has(id);
    }

    @Override
    public TemporalPropositionDefinition readTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return (TemporalPropositionDefinition)this.tempPropDefReader.read(id);
    }

    @Override
    public List<TemporalPropositionDefinition> readTemporalPropositionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.tempPropDefReader.read(propIds);
    }

    @Override
    public PropositionDefinition readPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.propDefReader.read(id);
    }

    @Override
    public List<PropositionDefinition> readPropositionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.propDefReader.read(propIds);
    }

    @Override
    public boolean hasPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.propDefReader.has(id);
    }

    @Override
    public AbstractionDefinition readAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        return (AbstractionDefinition)this.abstractionDefReader.read(id);
    }

    @Override
    public List<AbstractionDefinition> readAbstractionDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.abstractionDefReader.read(propIds);
    }

    @Override
    public ContextDefinition readContextDefinition(String id) throws KnowledgeSourceReadException {
        return (ContextDefinition)this.contextDefReader.read(id);
    }

    @Override
    public List<ContextDefinition> readContextDefinitions(String ... propIds) throws KnowledgeSourceReadException {
        return this.contextDefReader.read(propIds);
    }

    @Override
    public boolean hasAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        return this.abstractionDefReader.has(id);
    }

    @Override
    public boolean hasContextDefinition(String id) throws KnowledgeSourceReadException {
        return this.contextDefReader.has(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueSet readValueSet(String id) throws KnowledgeSourceReadException {
        ValueSet result = null;
        Map<String, Object> map = this.notFoundValueSetRequests;
        synchronized (map) {
            if (!this.notFoundValueSetRequests.containsKey(id) && this.propositionDefinitionCache != null) {
                PropositionDefinitionCache propositionDefinitionCache = this.propositionDefinitionCache;
                synchronized (propositionDefinitionCache) {
                    result = this.propositionDefinitionCache.getValueSet(id);
                    if (result == null) {
                        this.initializeIfNeeded("reading the value set {0}", id);
                        if (this.getBackends() != null) {
                            for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
                                result = backend.readValueSet(id);
                                if (result == null) continue;
                                try {
                                    this.propositionDefinitionCache.addValueSet(result);
                                }
                                catch (InvalidValueSetDefinitionException ex) {
                                    ProtempaUtil.logger().log(Level.SEVERE, "Error adding value set definition to cache", ex);
                                    throw new AssertionError((Object)("Error adding value set definition to cache: " + ex.getMessage()));
                                }
                                return result;
                            }
                            this.notFoundValueSetRequests.put(id, null);
                        }
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasValueSet(String id) throws KnowledgeSourceReadException {
        boolean result = false;
        Map<String, Object> map = this.notFoundValueSetRequests;
        // MONITORENTER : map
        if (!this.notFoundValueSetRequests.containsKey(id)) {
            if (this.propositionDefinitionCache != null) {
                KnowledgeSourceBackend[] knowledgeSourceBackendArray = this.propositionDefinitionCache;
                // MONITORENTER : this.propositionDefinitionCache
                result = this.propositionDefinitionCache.getValueSet(id) != null;
                // MONITOREXIT : knowledgeSourceBackendArray
            }
            if (!result) {
                this.initializeIfNeeded("reading the value set {0}", id);
                for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
                    boolean bl = result = backend.readValueSet(id) != null;
                    if (!result) continue;
                    // MONITOREXIT : map
                    return result;
                }
                this.notFoundValueSetRequests.put(id, null);
            }
        }
        // MONITOREXIT : map
        return result;
    }

    @Override
    public void close() throws SourceCloseException {
        this.clear();
        this.propositionDefinitionCache = null;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.propositionDefinitionCache != null) {
            Object object = this.propositionDefinitionCache;
            synchronized (object) {
                this.propositionDefinitionCache.clear();
            }
            object = this.inverseIsACache;
            synchronized (object) {
                this.inverseIsACache.clear();
            }
            object = this.abstractedFromCache;
            synchronized (object) {
                this.abstractedFromCache.clear();
            }
            object = this.subContextsCache;
            synchronized (object) {
                this.subContextsCache.clear();
            }
            object = this.inducedByCache;
            synchronized (object) {
                this.inducedByCache.clear();
            }
            object = this.abstractionDefReader;
            synchronized (object) {
                this.notFoundAbstractionDefinitionRequests.clear();
            }
            object = this.notFoundValueSetRequests;
            synchronized (object) {
                this.notFoundValueSetRequests.clear();
            }
            object = this.propDefReader;
            synchronized (object) {
                this.notFoundPropositionDefinitionRequests.clear();
            }
            this.inDataSourceGetter.clear();
            this.collectSubtreeGetter.clear();
        }
    }

    @Override
    public Set<String> collectPropIdDescendantsUsingAllNarrower(boolean inDataSourceOnly, String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition ids for {0} with inDataSource set to true", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.inDataSourceGetter.subtreePropIds(inDataSourceOnly, propIds);
    }

    @Override
    public Set<PropositionDefinition> collectPropDefDescendantsUsingAllNarrower(boolean inDataSourceOnly, String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition definitions for {0} with inDataSource set to true", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.inDataSourceGetter.subtreePropDefs(inDataSourceOnly, propIds);
    }

    @Override
    public Set<String> collectPropIdDescendantsUsingInverseIsA(String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition ids for {0}", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.collectSubtreeGetter.subtreePropIds(false, propIds);
    }

    @Override
    public Set<PropositionDefinition> collectPropDefDescendantsUsingInverseIsA(String ... propIds) throws KnowledgeSourceReadException {
        this.initializeIfNeeded("Getting proposition definitions for {0}", StringUtils.join((Object[])propIds, (String)","));
        ProtempaUtil.checkArrayForNullElement(propIds, "propIds");
        return this.collectSubtreeGetter.subtreePropDefs(false, propIds);
    }

    @Override
    public List<String> getPropositionDefinitionsByTerm(And<TermSubsumption> termSubsumptionClause) throws KnowledgeSourceReadException {
        ArrayList<String> result = new ArrayList<String>();
        this.initializeIfNeeded("getting proposition definitions by term");
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            result.addAll(backend.getPropositionsByTermSubsumption(termSubsumptionClause));
        }
        return result;
    }

    @Override
    public void backendUpdated(KnowledgeSourceBackendUpdatedEvent event) {
        this.clear();
        this.fireKnowledgeSourceUpdated();
    }

    private void fireKnowledgeSourceUpdated() {
        this.fireSourceUpdated(new KnowledgeSourceUpdatedEvent(this));
    }

    @Override
    public List<String> getMatchingPropIds(String searchKey) throws KnowledgeSourceReadException {
        ProtempaUtil.logger().log(Level.INFO, "Searching knowledge source For search string {0}", searchKey);
        Set<String> searchResults = this.getSearchResultsFromBackend(searchKey);
        return new ArrayList<String>(searchResults);
    }

    private Set<String> getSearchResultsFromBackend(String searchKey) throws KnowledgeSourceReadException {
        HashSet<String> results = new HashSet<String>();
        for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])this.getBackends()) {
            results.addAll(backend.getKnowledgeSourceSearchResults(searchKey));
        }
        return results;
    }

    private final class TemporalPropositionDefinitionReader
    extends AbstractDefinitionReader<TemporalPropositionDefinition> {
        private TemporalPropositionDefinitionReader() {
        }

        @Override
        protected boolean isInNotFound(String id) {
            return KnowledgeSourceImpl.this.notFoundTemporalPropositionDefinitionRequests.containsKey(id);
        }

        @Override
        protected void putInNotFound(String id) {
            KnowledgeSourceImpl.this.notFoundTemporalPropositionDefinitionRequests.put(id, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TemporalPropositionDefinition readFromKnowledgeBase(String id) {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                PropositionDefinition r;
                TemporalPropositionDefinition result = KnowledgeSourceImpl.this.propositionDefinitionCache.getTemporalPropositionDefinition(id);
                if (result == null && (r = KnowledgeSourceImpl.this.propositionDefinitionCache.getPropositionDefinition(id)) instanceof TemporalPropositionDefinition) {
                    try {
                        KnowledgeSourceImpl.this.propositionDefinitionCache.addTemporalPropositionDefinition((TemporalPropositionDefinition)r);
                    }
                    catch (InvalidPropositionIdException ex) {
                        throw new AssertionError((Object)"Should not happen");
                    }
                    result = (TemporalPropositionDefinition)r;
                }
                return result;
            }
        }

        @Override
        protected TemporalPropositionDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readTemporalPropositionDefinition(id);
        }

        @Override
        protected List<TemporalPropositionDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readTemporalPropositionDefinitions(ids.toArray(new String[ids.size()]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void putInKnowledgeBase(TemporalPropositionDefinition propDef) throws InvalidPropositionIdException {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                KnowledgeSourceImpl.this.propositionDefinitionCache.addTemporalPropositionDefinition(propDef);
                KnowledgeSourceImpl.this.propositionDefinitionCache.addPropositionDefinition(propDef);
            }
        }
    }

    private final class ContextDefinitionReader
    extends AbstractDefinitionReader<ContextDefinition> {
        private ContextDefinitionReader() {
        }

        @Override
        protected boolean isInNotFound(String id) {
            return KnowledgeSourceImpl.this.notFoundContextDefinitionRequests.containsKey(id);
        }

        @Override
        protected void putInNotFound(String id) {
            KnowledgeSourceImpl.this.notFoundContextDefinitionRequests.put(id, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ContextDefinition readFromKnowledgeBase(String id) {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                PropositionDefinition r;
                ContextDefinition result = KnowledgeSourceImpl.this.propositionDefinitionCache.getContextDefinition(id);
                if (result == null && (r = KnowledgeSourceImpl.this.propositionDefinitionCache.getPropositionDefinition(id)) instanceof ContextDefinition) {
                    try {
                        KnowledgeSourceImpl.this.propositionDefinitionCache.addContextDefinition((ContextDefinition)r);
                    }
                    catch (InvalidPropositionIdException ex) {
                        throw new AssertionError((Object)"Should not happen");
                    }
                    result = (ContextDefinition)r;
                }
                return result;
            }
        }

        @Override
        protected ContextDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readContextDefinition(id);
        }

        @Override
        protected List<ContextDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readContextDefinitions(ids.toArray(new String[ids.size()]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void putInKnowledgeBase(ContextDefinition propDef) throws InvalidPropositionIdException {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                KnowledgeSourceImpl.this.propositionDefinitionCache.addContextDefinition(propDef);
                KnowledgeSourceImpl.this.propositionDefinitionCache.addPropositionDefinition(propDef);
            }
        }
    }

    private final class AbstractionDefinitionReader
    extends AbstractDefinitionReader<AbstractionDefinition> {
        private AbstractionDefinitionReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractionDefinition readFromKnowledgeBase(String id) {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                PropositionDefinition r;
                AbstractionDefinition result = KnowledgeSourceImpl.this.propositionDefinitionCache.getAbstractionDefinition(id);
                if (result == null && (r = KnowledgeSourceImpl.this.propositionDefinitionCache.getPropositionDefinition(id)) instanceof AbstractionDefinition) {
                    try {
                        KnowledgeSourceImpl.this.propositionDefinitionCache.addAbstractionDefinition((AbstractionDefinition)r);
                    }
                    catch (InvalidPropositionIdException ex) {
                        throw new AssertionError((Object)"Should not happen");
                    }
                    result = (AbstractionDefinition)r;
                }
                return result;
            }
        }

        @Override
        protected AbstractionDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readAbstractionDefinition(id);
        }

        @Override
        protected List<AbstractionDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readAbstractionDefinitions(ids.toArray(new String[ids.size()]));
        }

        @Override
        protected boolean isInNotFound(String id) {
            return KnowledgeSourceImpl.this.notFoundAbstractionDefinitionRequests.containsKey(id);
        }

        @Override
        protected void putInNotFound(String id) {
            KnowledgeSourceImpl.this.notFoundAbstractionDefinitionRequests.put(id, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void putInKnowledgeBase(AbstractionDefinition propDef) throws InvalidPropositionIdException {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                KnowledgeSourceImpl.this.propositionDefinitionCache.addAbstractionDefinition(propDef);
                KnowledgeSourceImpl.this.propositionDefinitionCache.addTemporalPropositionDefinition(propDef);
                KnowledgeSourceImpl.this.propositionDefinitionCache.addPropositionDefinition(propDef);
            }
        }
    }

    private final class PropositionDefinitionReader
    extends AbstractDefinitionReader<PropositionDefinition> {
        private PropositionDefinitionReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PropositionDefinition readFromKnowledgeBase(String id) {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                return KnowledgeSourceImpl.this.propositionDefinitionCache.getPropositionDefinition(id);
            }
        }

        @Override
        protected PropositionDefinition readFromBackend(String id, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readPropositionDefinition(id);
        }

        @Override
        protected List<PropositionDefinition> readFromBackend(List<String> ids, KnowledgeSourceBackend backend) throws KnowledgeSourceReadException {
            return backend.readPropositionDefinitions(ids.toArray(new String[ids.size()]));
        }

        @Override
        protected boolean isInNotFound(String id) {
            return KnowledgeSourceImpl.this.notFoundPropositionDefinitionRequests.containsKey(id);
        }

        @Override
        protected void putInNotFound(String id) {
            KnowledgeSourceImpl.this.notFoundPropositionDefinitionRequests.put(id, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void putInKnowledgeBase(PropositionDefinition propDef) throws InvalidPropositionIdException {
            PropositionDefinitionCache propositionDefinitionCache = KnowledgeSourceImpl.this.propositionDefinitionCache;
            synchronized (propositionDefinitionCache) {
                KnowledgeSourceImpl.this.propositionDefinitionCache.addPropositionDefinition(propDef);
            }
        }
    }

    private abstract class AbstractDefinitionReader<E extends PropositionDefinition> {
        private AbstractDefinitionReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final E read(String id) throws KnowledgeSourceReadException {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            KnowledgeSourceImpl.this.initializeIfNeeded("reading the proposition definition {0}", new String[]{id});
            E result = null;
            AbstractDefinitionReader abstractDefinitionReader = this;
            synchronized (abstractDefinitionReader) {
                if (!this.isInNotFound(id) && KnowledgeSourceImpl.this.propositionDefinitionCache != null && (result = (E)this.readFromKnowledgeBase(id)) == null) {
                    for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])KnowledgeSourceImpl.this.getBackends()) {
                        result = this.readFromBackend(id, backend);
                        if (result == null) continue;
                        try {
                            this.putInKnowledgeBase(result);
                        }
                        catch (InvalidPropositionIdException ex) {
                            ProtempaUtil.logger().log(Level.SEVERE, "Error adding proposition definition to cache", ex);
                            throw new AssertionError((Object)("Error adding proposition definition to cache: " + ex.getMessage()));
                        }
                        return result;
                    }
                    this.putInNotFound(id);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final List<E> read(String[] ids) throws KnowledgeSourceReadException {
            assert (ids != null) : "ids cannot be null";
            KnowledgeSourceImpl.this.initializeIfNeeded("reading the proposition definitions {0}", ids);
            ArrayList result = new ArrayList();
            AbstractDefinitionReader abstractDefinitionReader = this;
            synchronized (abstractDefinitionReader) {
                ArrayList<String> propIdsToFind = new ArrayList<String>();
                for (String id : ids) {
                    if (this.isInNotFound(id) || KnowledgeSourceImpl.this.propositionDefinitionCache == null) continue;
                    E propDef = this.readFromKnowledgeBase(id);
                    if (propDef == null) {
                        propIdsToFind.add(id);
                        continue;
                    }
                    result.add(propDef);
                }
                ArrayList<E> resultNew = new ArrayList<E>();
                for (KnowledgeSourceBackend backend : (KnowledgeSourceBackend[])KnowledgeSourceImpl.this.getBackends()) {
                    resultNew.addAll(this.readFromBackend(propIdsToFind, backend));
                }
                try {
                    this.putInKnowledgeBase(resultNew);
                }
                catch (InvalidPropositionIdException ex) {
                    throw new AssertionError((Object)("Error adding proposition definition to cache: " + ex.getMessage()));
                }
                result.addAll(resultNew);
            }
            return result;
        }

        final boolean has(String id) throws KnowledgeSourceReadException {
            if (id == null) {
                throw new IllegalArgumentException("id cannot be null");
            }
            return this.read(id) != null;
        }

        protected abstract boolean isInNotFound(String var1);

        protected abstract void putInNotFound(String var1);

        protected abstract E readFromKnowledgeBase(String var1);

        protected abstract E readFromBackend(String var1, KnowledgeSourceBackend var2) throws KnowledgeSourceReadException;

        protected abstract List<E> readFromBackend(List<String> var1, KnowledgeSourceBackend var2) throws KnowledgeSourceReadException;

        protected abstract void putInKnowledgeBase(E var1) throws InvalidPropositionIdException;

        void putInKnowledgeBase(List<E> propDefs) throws InvalidPropositionIdException {
            for (PropositionDefinition propDef : propDefs) {
                this.putInKnowledgeBase(propDef);
            }
        }
    }
}

