/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamerIterator;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventHandler;
import org.protempa.DataStreamingEventIterator;
import org.protempa.PropositionDataStreamerProcessor;
import org.protempa.proposition.Proposition;

public class MultiplexingDataStreamingEventIterator
implements DataStreamingEventIterator<Proposition> {
    private final MultiplexingDataStreamingEventHandler handler;
    private DataStreamerIterator itr;
    private final PropositionDataStreamerProcessor processor;
    private final List<? extends DataStreamingEventIterator<Proposition>> itrs;
    private DataStreamingEvent<Proposition> next;

    MultiplexingDataStreamingEventIterator(List<? extends DataStreamingEventIterator<Proposition>> itrs, PropositionDataStreamerProcessor processor) {
        if (itrs == null) {
            throw new IllegalArgumentException("itrs cannot be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null");
        }
        this.itrs = itrs;
        this.processor = processor;
        this.handler = new MultiplexingDataStreamingEventHandler();
        this.processor.setHandler(this.handler);
    }

    @Override
    public boolean hasNext() throws DataSourceReadException {
        if (this.next == null) {
            if (this.itr == null) {
                this.itr = new DataStreamerIterator(this.itrs);
            }
            boolean stopOnNext = false;
            while (this.itr.hasNext() && !stopOnNext) {
                if (this.processor.getKeyId() != null && !this.processor.getKeyId().equals(this.itr.getNextKeyId())) {
                    stopOnNext = true;
                }
                this.processor.execute(this.itr.next());
                if (this.handler.event == null) continue;
                this.next = this.handler.event;
                this.handler.event = null;
                return true;
            }
            if (!stopOnNext) {
                this.processor.finish();
                if (this.handler.event != null) {
                    this.next = this.handler.event;
                    this.handler.event = null;
                    return true;
                }
            }
        }
        return this.next != null;
    }

    @Override
    public DataStreamingEvent<Proposition> next() throws DataSourceReadException {
        if (this.hasNext()) {
            DataStreamingEvent<Proposition> result = this.next;
            this.next = null;
            return result;
        }
        throw new NoSuchElementException("Past end of iterator");
    }

    @Override
    public void close() throws DataSourceReadException {
        ArrayList<DataSourceReadException> exceptions = new ArrayList<DataSourceReadException>();
        if (this.itr != null) {
            this.itr.close();
        }
        this.processor.close();
        for (DataStreamingEventIterator<Proposition> dataStreamingEventIterator : this.itrs) {
            try {
                dataStreamingEventIterator.close();
            }
            catch (DataSourceReadException dataSourceReadException) {
                exceptions.add(dataSourceReadException);
            }
        }
        if (!exceptions.isEmpty()) {
            ArrayList stes = new ArrayList();
            for (Exception exception : exceptions) {
                Arrays.addAll(stes, (Object[][])new StackTraceElement[][]{exception.getStackTrace()});
            }
            DataSourceReadException dataSourceReadException = new DataSourceReadException(exceptions.size() + " data source backend(s) failed");
            dataSourceReadException.setStackTrace(stes.toArray(new StackTraceElement[stes.size()]));
            throw dataSourceReadException;
        }
    }

    private static class MultiplexingDataStreamingEventHandler
    implements DataStreamingEventHandler {
        private DataStreamingEvent<Proposition> event;

        private MultiplexingDataStreamingEventHandler() {
        }

        @Override
        public void handle(String keyId, List<Proposition> propositions) {
            this.event = new DataStreamingEvent<Proposition>(keyId, propositions);
        }
    }
}

