/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.protempa.CollectSubtreeGetterSlowStrategy;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;

class SubtreePropositionDefinitionGetterForWrapper {
    private final CollectSubtreeGetterSlowStrategy inDataSourceSlowStrategy;
    private final CollectSubtreeGetterSlowStrategy collectSubtreeSlowStrategy;
    private final Map<String, PropositionDefinition> propositionDefinitionMap;
    private final KnowledgeSource knowledgeSource;
    private final boolean allNarrower;

    SubtreePropositionDefinitionGetterForWrapper(Map<String, PropositionDefinition> propositionDefinitionMap, KnowledgeSource knowledgeSource, boolean allNarrower) {
        assert (propositionDefinitionMap != null) : "propositionDefinitionMap cannot be null";
        assert (knowledgeSource != null) : "knowledgeSource cannot be null";
        this.propositionDefinitionMap = propositionDefinitionMap;
        this.inDataSourceSlowStrategy = new CollectSubtreeGetterSlowStrategy(this.propositionDefinitionMap, true);
        this.collectSubtreeSlowStrategy = new CollectSubtreeGetterSlowStrategy(this.propositionDefinitionMap, false);
        this.knowledgeSource = knowledgeSource;
        this.allNarrower = allNarrower;
    }

    Set<String> collectPropIds(boolean inDataSource, String ... propIds) throws KnowledgeSourceReadException {
        Set propIdsAsSet = Arrays.asSet((Object[])propIds);
        CollectSubtreeGetterSlowStrategy.InDataSourceResult<String> partialResult = this.allNarrower ? this.inDataSourceSlowStrategy.collectPropIds(inDataSource, propIdsAsSet) : this.collectSubtreeSlowStrategy.collectPropIds(inDataSource, propIdsAsSet);
        HashSet<String> result = new HashSet<String>(partialResult.getResult());
        propIdsAsSet.removeAll(result);
        propIdsAsSet.addAll(partialResult.getMissing());
        String[] partialResultArr = propIdsAsSet.toArray(new String[propIdsAsSet.size()]);
        if (this.allNarrower) {
            result.addAll(this.knowledgeSource.collectPropIdDescendantsUsingAllNarrower(inDataSource, partialResultArr));
        } else {
            result.addAll(this.knowledgeSource.collectPropIdDescendantsUsingInverseIsA(partialResultArr));
        }
        return result;
    }

    Set<PropositionDefinition> collectPropDefs(boolean inDataSource, String ... propIds) throws KnowledgeSourceReadException {
        Set propIdsAsSet = Arrays.asSet((Object[])propIds);
        CollectSubtreeGetterSlowStrategy.InDataSourceResult<PropositionDefinition> partialResult = this.allNarrower ? this.inDataSourceSlowStrategy.collectPropDefs(inDataSource, propIdsAsSet) : this.collectSubtreeSlowStrategy.collectPropDefs(inDataSource, propIdsAsSet);
        HashSet<PropositionDefinition> result = new HashSet<PropositionDefinition>(partialResult.getResult());
        for (PropositionDefinition pd : result) {
            propIdsAsSet.remove(pd.getId());
        }
        propIdsAsSet.addAll(partialResult.getMissing());
        String[] partialResultArr = propIdsAsSet.toArray(new String[propIdsAsSet.size()]);
        if (this.allNarrower) {
            result.addAll(this.knowledgeSource.collectPropDefDescendantsUsingAllNarrower(inDataSource, partialResultArr));
        } else {
            result.addAll(this.knowledgeSource.collectPropDefDescendantsUsingInverseIsA(partialResultArr));
        }
        return result;
    }

    void clear() {
        this.inDataSourceSlowStrategy.clear();
    }
}

