/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.filter.Filter;

public abstract class AbstractFilter
implements Filter {
    private final String[] propositionIds;
    private Filter and;

    public AbstractFilter(String[] propositionIds) {
        ProtempaUtil.checkArray(propositionIds, "propositionIds");
        propositionIds = (String[])propositionIds.clone();
        ProtempaUtil.internAll(propositionIds);
        this.propositionIds = propositionIds;
    }

    @Override
    public String[] getPropositionIds() {
        return (String[])this.propositionIds.clone();
    }

    public void setAnd(Filter and) {
        this.and = and;
    }

    @Override
    public Filter getAnd() {
        return this.and;
    }

    @Override
    public Iterator<Filter> andIterator() {
        return new DataSourceConstraintAndIterator(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Filter filterArrayToChain(Filter[] filterArray) {
        for (int i = 0; i < filterArray.length - 1; ++i) {
            AbstractFilter thisFilter = (AbstractFilter)filterArray[i];
            thisFilter.setAnd(filterArray[i + 1]);
        }
        AbstractFilter lastFilter = (AbstractFilter)filterArray[filterArray.length - 1];
        lastFilter.setAnd(null);
        return filterArray[0];
    }

    public int chainLength() {
        AbstractFilter thisFilter = (AbstractFilter)this.and;
        int length = 1;
        while (thisFilter != null) {
            ++length;
            thisFilter = (AbstractFilter)thisFilter.and;
        }
        return length;
    }

    @Override
    public Filter[] filterChainToArray() {
        int length = this.chainLength();
        Filter[] array = new Filter[length];
        Filter thisFilter = this;
        for (int i = 0; i < length; ++i) {
            array[i] = thisFilter;
            thisFilter = thisFilter.getAnd();
        }
        return array;
    }

    private static class DataSourceConstraintAndIterator
    implements Iterator<Filter> {
        private Filter dataSourceConstraint;

        private DataSourceConstraintAndIterator(Filter dataSourceConstraint) {
            assert (dataSourceConstraint != null) : "dataSourceConstraint cannot be null";
            this.dataSourceConstraint = dataSourceConstraint;
        }

        @Override
        public boolean hasNext() {
            return this.dataSourceConstraint != null;
        }

        @Override
        public Filter next() {
            if (this.dataSourceConstraint != null) {
                Filter dsc = this.dataSourceConstraint;
                this.dataSourceConstraint = this.dataSourceConstraint.getAnd();
                return dsc;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

