/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.List;
import java.util.Map;
import org.protempa.KnowledgeSourceCache;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkTraverser;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.dest.table.TableColumnSpec;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;

public abstract class AbstractTableColumnSpec
implements TableColumnSpec {
    private final LinkTraverser linkTraverser = new LinkTraverser();

    boolean checkCompatible(Proposition proposition, PropertyConstraint[] constraints) {
        for (PropertyConstraint ccc : constraints) {
            String propName = ccc.getPropertyName();
            Value value = proposition.getProperty(propName);
            ValueComparator vc = ccc.getValueComparator();
            if (vc.compare(value, ccc.getValue())) continue;
            return false;
        }
        return true;
    }

    String generateLinksHeaderString(Link[] links) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < links.length; ++i) {
            result.append(links[i].headerFragment());
        }
        return result.toString();
    }

    List<Proposition> traverseLinks(Link[] links, Proposition proposition, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache) {
        return this.linkTraverser.traverseLinks(links, proposition, forwardDerivations, backwardDerivations, references, ksCache);
    }
}

