/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.RandomAccess;
import org.protempa.proposition.PropositionUtil;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;

public class Segment<T extends TemporalProposition>
extends AbstractList<T>
implements RandomAccess {
    private static final IntervalFactory intervalFactory = new IntervalFactory();
    private Sequence<T> ts;
    private int x = -1;
    private int y = -1;
    protected int modCount = 0;
    private boolean intervalStale = true;
    private T maxFinishParam;
    private Interval interval;
    private Comparator<TemporalProposition> MAX_START_COMP = new Comparator<TemporalProposition>(){

        @Override
        public int compare(TemporalProposition p0, TemporalProposition p1) {
            Long p0MaxStart = p0.getInterval().getMaximumStart();
            Long p1MaxStart = p1.getInterval().getMaximumStart();
            if (p0MaxStart != null && p1MaxStart != null) {
                return p0MaxStart.compareTo(p1MaxStart);
            }
            if (p0MaxStart != null) {
                return -1;
            }
            if (p1MaxStart != null) {
                return 1;
            }
            return 0;
        }
    };
    private Comparator<TemporalProposition> MIN_FINISH_COMP = new Comparator<TemporalProposition>(){

        @Override
        public int compare(TemporalProposition p0, TemporalProposition p1) {
            Long p0MinFinish = p0.getInterval().getMinimumFinish();
            Long p1MinFinish = p1.getInterval().getMinimumFinish();
            if (p0MinFinish != null && p1MinFinish != null) {
                return p0MinFinish.compareTo(p1MinFinish);
            }
            if (p0MinFinish != null) {
                return 1;
            }
            if (p1MinFinish != null) {
                return -1;
            }
            return 0;
        }
    };

    public Segment(Sequence<T> seq, int firstIndex, int lastIndex) {
        if (seq == null) {
            throw new IllegalArgumentException("seq cannot be null!");
        }
        this.resetState(seq, firstIndex, lastIndex);
    }

    public Segment(Sequence<T> seq) {
        this(seq, 0, seq != null ? seq.size() - 1 : 0);
    }

    public Segment(Segment<T> segment) {
        this(segment != null ? segment.ts : null, segment != null ? segment.getFirstIndex() : 0, segment != null ? segment.getLastIndex() : 0);
    }

    public Sequence<T> getSequence() {
        return this.ts;
    }

    public Interval getInterval() {
        if (this.intervalStale || this.interval == null) {
            this.interval = this.intervalCreator();
            this.intervalStale = false;
        }
        return this.interval;
    }

    protected Interval intervalCreator() {
        if (this.size() == 1) {
            return ((TemporalProposition)this.first()).getInterval();
        }
        Long minStart = this.minimumStart(this);
        Long maxStart = this.maximumStart(this);
        Long minFinish = this.minimumFinish(this);
        Long maxFinish = this.maximumFinish(this);
        return intervalFactory.getInstance(minStart, maxStart, this.getStartGranularity(), minFinish, maxFinish, this.getFinishGranularity());
    }

    public int getFirstIndex() {
        if (this.x == -1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.x;
    }

    public int getLastIndex() {
        if (this.y == -1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.y;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof TemporalProposition)) {
            return -1;
        }
        return Collections.binarySearch(this, (TemporalProposition)o, PropositionUtil.TEMP_PROP_COMP);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public T first() {
        return (T)this.ts.get(this.getFirstIndex());
    }

    public T last() {
        return (T)this.ts.get(this.getLastIndex());
    }

    public Granularity getFinishGranularity() {
        this.calcMaxFinishParam();
        return ((TemporalProposition)this.maxFinishParam).getInterval().getFinishGranularity();
    }

    public Granularity getStartGranularity() {
        return ((TemporalProposition)this.first()).getInterval().getStartGranularity();
    }

    @Override
    public int size() {
        if (this.x == -1) {
            return 0;
        }
        return this.y - this.x + 1;
    }

    private void calcMaxFinishParam() {
        if (this.maxFinishParam == null) {
            this.maxFinishParam = Collections.max(this, PropositionUtil.MAX_FINISH_COMP);
        }
    }

    public Segment<T> resetState(Sequence<T> sequence) {
        if (sequence == null) {
            return null;
        }
        return this.resetState(sequence, 0, sequence.size() - 1);
    }

    public Segment<T> resetState(Sequence<T> sequence, int firstIndex, int lastIndex) {
        if (sequence == null || firstIndex >= sequence.size() || lastIndex >= sequence.size() || firstIndex > lastIndex) {
            return null;
        }
        this.ts = sequence;
        this.x = firstIndex;
        this.y = lastIndex;
        ++this.modCount;
        this.intervalStale = true;
        this.maxFinishParam = null;
        return this;
    }

    @Override
    public T get(int index) {
        return (T)this.ts.get(this.x + index);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    private Long maximumFinish(Segment<T> segment) {
        this.calcMaxFinishParam();
        return ((TemporalProposition)this.maxFinishParam).getInterval().getMaxFinish();
    }

    private Long minimumStart(Segment<T> segment) {
        return ((TemporalProposition)segment.first()).getInterval().getMinStart();
    }

    private Long maximumStart(Segment<T> segment) {
        return Collections.min(segment, this.MAX_START_COMP).getInterval().getMaxStart();
    }

    private Long minimumFinish(Segment<T> segment) {
        return Collections.max(segment, this.MIN_FINISH_COMP).getInterval().getMinFinish();
    }
}

