/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.ObjectStreamException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.AbsoluteTimeUnit;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.ReprSimpleDateFormat;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.ValueUtil;

public final class AbsoluteTimeGranularity
implements Granularity {
    private static final long serialVersionUID = -4868042711375950931L;
    private static final ResourceBundle resourceBundle = ValueUtil.resourceBundle();
    private static final String[] ABBREV_NAMES = new String[]{resourceBundle.getString("time_field_abbrev_sec"), resourceBundle.getString("time_field_abbrev_min"), resourceBundle.getString("time_field_abbrev_hr"), resourceBundle.getString("time_field_abbrev_day"), resourceBundle.getString("time_field_abbrev_month"), resourceBundle.getString("time_field_abbrev_yr")};
    private static final String[] NAMES = new String[]{resourceBundle.getString("time_field_singular_sec"), resourceBundle.getString("time_field_singular_min"), resourceBundle.getString("time_field_singular_hr"), resourceBundle.getString("time_field_singular_day"), resourceBundle.getString("time_field_singular_month"), resourceBundle.getString("time_field_singular_yr")};
    private static final String[] PLURAL_NAMES = new String[]{resourceBundle.getString("time_field_plural_sec"), resourceBundle.getString("time_field_plural_min"), resourceBundle.getString("time_field_plural_hr"), resourceBundle.getString("time_field_plural_day"), resourceBundle.getString("time_field_plural_month"), resourceBundle.getString("time_field_plural_yr")};
    private static final List<ThreadLocal<DateFormat>> longDateFormats = new ArrayList<ThreadLocal<DateFormat>>();
    private static final List<ThreadLocal<DateFormat>> reprFormats;
    private static final List<ThreadLocal<DateFormat>> longDateFormatsNoYear;
    private static final List<ThreadLocal<DateFormat>> mediumDateFormats;
    private static final List<ThreadLocal<DateFormat>> mediumDateFormatsNoYear;
    private static final List<ThreadLocal<DateFormat>> shortDateFormats;
    private static final List<ThreadLocal<DateFormat>> shortDateFormatsNoYear;
    private static final List<ThreadLocal<DateFormat>> timeFormats;
    private static final int[] CALENDAR_TIME_UNITS;
    public static final AbsoluteTimeGranularity SECOND;
    public static final AbsoluteTimeGranularity MINUTE;
    public static final AbsoluteTimeGranularity HOUR;
    public static final AbsoluteTimeGranularity DAY;
    public static final AbsoluteTimeGranularity MONTH;
    public static final AbsoluteTimeGranularity YEAR;
    private static final AbsoluteTimeGranularity[] VALUES;
    private static volatile int nextOrdinal;
    private final transient String abbrev;
    private final transient String name;
    private final transient String pluralName;
    private final transient int calUnitIndex;
    private final transient ThreadLocal<DateFormat> longDateFormat;
    private final transient ThreadLocal<DateFormat> longDateFormatNoYear;
    private final transient ThreadLocal<DateFormat> mediumDateFormat;
    private final transient ThreadLocal<DateFormat> mediumDateFormatNoYear;
    private final transient ThreadLocal<DateFormat> shortDateFormat;
    private final transient ThreadLocal<DateFormat> shortDateFormatNoYear;
    private final transient ThreadLocal<DateFormat> timeFormat;
    private final transient ThreadLocal<DateFormat> reprFormat;
    private final transient Calendar earliestCal;
    private final transient Calendar latestCal;
    private final transient Calendar minDistCal;
    private final transient Calendar maxDistCal;
    private final transient Calendar distToCal;
    private final transient Unit correspondingUnit;
    private int ordinal = nextOrdinal++;

    public static String toSQLString(Long position) {
        Date date = AbsoluteTimeGranularityUtil.asDate(position);
        return new Timestamp(date.getTime()).toString();
    }

    public static AbsoluteTimeGranularity granularityStringToGranularity(String string) {
        int pos = AbsoluteTimeGranularity.validatePluralName(string);
        if (pos == -1) {
            return null;
        }
        return VALUES[pos];
    }

    public static AbsoluteTimeGranularity nameToGranularity(String name) {
        int pos = AbsoluteTimeGranularity.validateName(name);
        if (pos == -1) {
            return null;
        }
        return VALUES[pos];
    }

    private static int validatePluralName(String unitString) {
        int pos = -1;
        for (int i = 0; i < PLURAL_NAMES.length; ++i) {
            if (!PLURAL_NAMES[i].equals(unitString)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private static int validateName(String unitString) {
        int pos = -1;
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equals(unitString)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private AbsoluteTimeGranularity(String abbrev, String name, String pluralName, int calUnitIndex, ThreadLocal<DateFormat> longDateFormat, ThreadLocal<DateFormat> longDateFormatNoYear, ThreadLocal<DateFormat> mediumDateFormat, ThreadLocal<DateFormat> mediumDateFormatNoYear, ThreadLocal<DateFormat> shortDateFormat, ThreadLocal<DateFormat> shortDateFormatNoYear, ThreadLocal<DateFormat> timeFormat, ThreadLocal<DateFormat> reprFormat, Unit correspondingUnit) {
        this.abbrev = abbrev;
        this.name = name;
        this.pluralName = pluralName;
        this.calUnitIndex = calUnitIndex;
        this.longDateFormat = longDateFormat;
        this.longDateFormatNoYear = longDateFormatNoYear;
        this.mediumDateFormat = mediumDateFormat;
        this.mediumDateFormatNoYear = mediumDateFormatNoYear;
        this.shortDateFormat = shortDateFormat;
        this.shortDateFormatNoYear = shortDateFormatNoYear;
        this.timeFormat = timeFormat;
        this.reprFormat = reprFormat;
        this.earliestCal = Calendar.getInstance();
        this.latestCal = Calendar.getInstance();
        this.minDistCal = Calendar.getInstance();
        this.maxDistCal = Calendar.getInstance();
        this.distToCal = Calendar.getInstance();
        this.correspondingUnit = correspondingUnit;
    }

    @Override
    public String getPluralName() {
        return this.pluralName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbbrevatedName() {
        return this.abbrev;
    }

    public String toString() {
        return this.name;
    }

    public Format getReprFormat() {
        return this.reprFormat.get();
    }

    @Override
    public DateFormat getLongFormat() {
        return this.longDateFormat.get();
    }

    public DateFormat getLongDateFormatNoYear() {
        return this.longDateFormatNoYear.get();
    }

    @Override
    public DateFormat getMediumFormat() {
        return this.mediumDateFormat.get();
    }

    public DateFormat getMediumDateFormatNoYear() {
        return this.mediumDateFormatNoYear.get();
    }

    @Override
    public DateFormat getShortFormat() {
        return this.shortDateFormat.get();
    }

    public DateFormat getShortDateFormatNoYear() {
        return this.shortDateFormatNoYear.get();
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat.get();
    }

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long earliest(long pos) {
        Calendar calendar = this.earliestCal;
        synchronized (calendar) {
            this.earliestCal.setTimeInMillis(pos);
            this.zeroCalendar(this.earliestCal);
            return this.earliestCal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long latest(long pos) {
        Calendar calendar = this.latestCal;
        synchronized (calendar) {
            this.latestCal.setTimeInMillis(pos);
            this.latestCal.add(CALENDAR_TIME_UNITS[this.calUnitIndex], 1);
            this.latestCal.add(CALENDAR_TIME_UNITS[0], -1);
            return this.latestCal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long maximumDistance(long position, long distance, Unit distanceUnit) {
        if (distance == 0L) {
            return 0L;
        }
        Calendar calendar = this.maxDistCal;
        synchronized (calendar) {
            this.maxDistCal.setTimeInMillis(position);
            long initial = this.maxDistCal.getTimeInMillis();
            int calUnits = distanceUnit == null ? CALENDAR_TIME_UNITS[0] : ((AbsoluteTimeUnit)distanceUnit).getCalendarUnits();
            for (long d = 0L; d < distance; d += Integer.MAX_VALUE) {
                int dAsInt = (int)Math.min(Integer.MAX_VALUE, distance - d);
                this.maxDistCal.add(calUnits, dAsInt);
            }
            this.maxDistCal.add(calUnits, 1);
            this.maxDistCal.add(CALENDAR_TIME_UNITS[0], -1);
            return this.maxDistCal.getTimeInMillis() - initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long minimumDistance(long position, long distance, Unit distanceUnit) {
        if (distance == 0L) {
            return 0L;
        }
        Calendar calendar = this.minDistCal;
        synchronized (calendar) {
            this.minDistCal.setTimeInMillis(position);
            long initial = this.minDistCal.getTimeInMillis();
            int calUnits = distanceUnit == null ? CALENDAR_TIME_UNITS[0] : ((AbsoluteTimeUnit)distanceUnit).getCalendarUnits();
            for (long d = 0L; d < distance; d += Integer.MAX_VALUE) {
                int dAsInt = (int)Math.min(Integer.MAX_VALUE, distance - d);
                this.minDistCal.add(calUnits, dAsInt);
            }
            this.minDistCal.add(calUnits, -1);
            this.minDistCal.add(CALENDAR_TIME_UNITS[0], 1);
            return this.minDistCal.getTimeInMillis() - initial;
        }
    }

    private void zeroCalendar(Calendar cal) {
        for (int i = this.calUnitIndex - 1; i >= 0; --i) {
            cal.set(CALENDAR_TIME_UNITS[i], cal.getActualMinimum(CALENDAR_TIME_UNITS[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long distance(long start, long finish, Granularity finishGranularity, Unit distanceUnit) {
        if (distanceUnit == null) {
            return finish - start;
        }
        AbsoluteTimeUnit du = (AbsoluteTimeUnit)distanceUnit;
        if (du.isUsingFastDurationCalculations()) {
            return (finish - start) / du.getLength();
        }
        Calendar calendar = this.distToCal;
        synchronized (calendar) {
            this.distToCal.setTimeInMillis(start);
            int calUnits = du.getCalendarUnits();
            int returnValue = 0;
            while (true) {
                this.distToCal.add(calUnits, 1);
                if (this.distToCal.getTimeInMillis() > finish) break;
                ++returnValue;
            }
            return returnValue;
        }
    }

    @Override
    public int compareTo(Granularity o) {
        AbsoluteTimeGranularity other = (AbsoluteTimeGranularity)o;
        return this.ordinal - other.ordinal;
    }

    @Override
    public Unit getCorrespondingUnit() {
        return this.correspondingUnit;
    }

    public int hashCode() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteTimeGranularity other = (AbsoluteTimeGranularity)obj;
        return this.ordinal == other.ordinal;
    }

    static {
        longDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_sec"));
            }
        });
        longDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_min"));
            }
        });
        longDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_hr"));
            }
        });
        longDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_day"));
            }
        });
        longDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_month"));
            }
        });
        longDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_yr"));
            }
        });
        reprFormats = new ArrayList<ThreadLocal<DateFormat>>();
        reprFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new ReprSimpleDateFormat(resourceBundle.getString("long_date_format_gran_sec"));
            }
        });
        reprFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new ReprSimpleDateFormat(resourceBundle.getString("long_date_format_gran_min"));
            }
        });
        reprFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new ReprSimpleDateFormat(resourceBundle.getString("long_date_format_gran_hr"));
            }
        });
        reprFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new ReprSimpleDateFormat(resourceBundle.getString("long_date_format_gran_day"));
            }
        });
        reprFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new ReprSimpleDateFormat(resourceBundle.getString("long_date_format_gran_month"));
            }
        });
        reprFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new ReprSimpleDateFormat(resourceBundle.getString("long_date_format_gran_yr"));
            }
        });
        longDateFormatsNoYear = new ArrayList<ThreadLocal<DateFormat>>();
        longDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_sec_no_yr"));
            }
        });
        longDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_min_no_yr"));
            }
        });
        longDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_hr_no_yr"));
            }
        });
        longDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_day_no_yr"));
            }
        });
        longDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_month_no_yr"));
            }
        });
        longDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("long_date_format_gran_yr_no_yr"));
            }
        });
        mediumDateFormats = new ArrayList<ThreadLocal<DateFormat>>();
        mediumDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_sec"));
            }
        });
        mediumDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_min"));
            }
        });
        mediumDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_hr"));
            }
        });
        mediumDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_day"));
            }
        });
        mediumDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_month"));
            }
        });
        mediumDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_yr"));
            }
        });
        mediumDateFormatsNoYear = new ArrayList<ThreadLocal<DateFormat>>();
        mediumDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_sec_no_yr"));
            }
        });
        mediumDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_min_no_yr"));
            }
        });
        mediumDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_hr_no_yr"));
            }
        });
        mediumDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_day_no_yr"));
            }
        });
        mediumDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_month_no_yr"));
            }
        });
        mediumDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("med_date_format_gran_yr_no_yr"));
            }
        });
        shortDateFormats = new ArrayList<ThreadLocal<DateFormat>>();
        shortDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_sec"));
            }
        });
        shortDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_min"));
            }
        });
        shortDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_hr"));
            }
        });
        shortDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_day"));
            }
        });
        shortDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_month"));
            }
        });
        shortDateFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_yr"));
            }
        });
        shortDateFormatsNoYear = new ArrayList<ThreadLocal<DateFormat>>();
        shortDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_sec_no_yr"));
            }
        });
        shortDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_min_no_yr"));
            }
        });
        shortDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_hr_no_yr"));
            }
        });
        shortDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_day_no_yr"));
            }
        });
        shortDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_month_no_yr"));
            }
        });
        shortDateFormatsNoYear.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("short_date_format_gran_yr_no_yr"));
            }
        });
        timeFormats = new ArrayList<ThreadLocal<DateFormat>>();
        timeFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("time_format_gran_sec"));
            }
        });
        timeFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("time_format_gran_min"));
            }
        });
        timeFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("time_format_gran_hr"));
            }
        });
        timeFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("time_format_gran_hr"));
            }
        });
        timeFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("time_format_gran_hr"));
            }
        });
        timeFormats.add(new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(resourceBundle.getString("time_format_gran_hr"));
            }
        });
        CALENDAR_TIME_UNITS = new int[]{14, 13, 12, 11, 5, 2, 1};
        SECOND = new AbsoluteTimeGranularity(ABBREV_NAMES[0], NAMES[0], PLURAL_NAMES[0], 1, longDateFormats.get(0), longDateFormatsNoYear.get(0), mediumDateFormats.get(0), mediumDateFormatsNoYear.get(0), shortDateFormats.get(0), shortDateFormatsNoYear.get(0), timeFormats.get(0), reprFormats.get(0), AbsoluteTimeUnit.SECOND);
        MINUTE = new AbsoluteTimeGranularity(ABBREV_NAMES[1], NAMES[1], PLURAL_NAMES[1], 2, longDateFormats.get(1), longDateFormatsNoYear.get(1), mediumDateFormats.get(1), mediumDateFormatsNoYear.get(1), shortDateFormats.get(1), shortDateFormatsNoYear.get(1), timeFormats.get(1), reprFormats.get(1), AbsoluteTimeUnit.MINUTE);
        HOUR = new AbsoluteTimeGranularity(ABBREV_NAMES[2], NAMES[2], PLURAL_NAMES[2], 3, longDateFormats.get(2), longDateFormatsNoYear.get(2), mediumDateFormats.get(2), mediumDateFormatsNoYear.get(2), shortDateFormats.get(2), shortDateFormatsNoYear.get(2), timeFormats.get(2), reprFormats.get(2), AbsoluteTimeUnit.HOUR);
        DAY = new AbsoluteTimeGranularity(ABBREV_NAMES[3], NAMES[3], PLURAL_NAMES[3], 4, longDateFormats.get(3), longDateFormatsNoYear.get(3), mediumDateFormats.get(3), mediumDateFormatsNoYear.get(3), shortDateFormats.get(3), shortDateFormatsNoYear.get(3), timeFormats.get(3), reprFormats.get(3), AbsoluteTimeUnit.DAY);
        MONTH = new AbsoluteTimeGranularity(ABBREV_NAMES[4], NAMES[4], PLURAL_NAMES[4], 5, longDateFormats.get(4), longDateFormatsNoYear.get(4), mediumDateFormats.get(4), mediumDateFormatsNoYear.get(4), shortDateFormats.get(4), shortDateFormatsNoYear.get(4), timeFormats.get(4), reprFormats.get(4), AbsoluteTimeUnit.MONTH);
        YEAR = new AbsoluteTimeGranularity(ABBREV_NAMES[5], NAMES[5], PLURAL_NAMES[5], 6, longDateFormats.get(5), longDateFormatsNoYear.get(5), mediumDateFormats.get(5), mediumDateFormatsNoYear.get(5), shortDateFormats.get(5), shortDateFormatsNoYear.get(5), timeFormats.get(5), reprFormats.get(5), AbsoluteTimeUnit.YEAR);
        VALUES = new AbsoluteTimeGranularity[]{SECOND, MINUTE, HOUR, DAY, MONTH, YEAR};
        nextOrdinal = 0;
    }
}

