/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb;

import java.util.Comparator;
import java.util.Set;
import org.protempa.BackendCloseException;
import org.protempa.DataSourceBackendSourceSystem;
import org.protempa.DataSourceReadException;
import org.protempa.DataSourceWriteException;
import org.protempa.KeySetSpec;
import org.protempa.backend.AbstractBackend;
import org.protempa.backend.DataSourceBackendUpdatedEvent;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.proposition.value.AbsoluteTimeGranularityFactory;
import org.protempa.proposition.value.AbsoluteTimeUnitFactory;
import org.protempa.proposition.value.GranularityFactory;
import org.protempa.proposition.value.UnitFactory;

public abstract class AbstractDataSourceBackend
extends AbstractBackend<DataSourceBackendUpdatedEvent>
implements DataSourceBackend {
    private static final AbsoluteTimeUnitFactory absTimeUnitFactory = new AbsoluteTimeUnitFactory();
    private static final AbsoluteTimeGranularityFactory absTimeGranularityFactory = new AbsoluteTimeGranularityFactory();
    private String keyType;
    private GranularityFactory granularityFactory = absTimeGranularityFactory;
    private UnitFactory unitFactory = absTimeUnitFactory;
    private Comparator<Object> keyIdComparator;

    protected AbstractDataSourceBackend() {
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    @Override
    public GranularityFactory getGranularityFactory() {
        return this.granularityFactory;
    }

    public void setGranularityFactory(GranularityFactory granularityFactory) {
        this.granularityFactory = granularityFactory == null ? absTimeGranularityFactory : granularityFactory;
    }

    @Override
    public UnitFactory getUnitFactory() {
        return this.unitFactory;
    }

    public void setUnitFactory(UnitFactory unitFactory) {
        this.unitFactory = unitFactory == null ? absTimeUnitFactory : unitFactory;
    }

    public void setKeyIdComparator(Comparator<Object> keyIdComparator) {
        this.keyIdComparator = keyIdComparator;
    }

    @Override
    public Comparator<Object> getKeyIdComparator() {
        return this.keyIdComparator;
    }

    @Override
    public void close() throws BackendCloseException {
    }

    @Override
    public String getKeyTypeDisplayName() {
        return this.getKeyType();
    }

    @Override
    public String getKeyTypePluralDisplayName() {
        return this.getKeyTypeDisplayName() + "s";
    }

    @Override
    public KeySetSpec[] getSelectedKeySetSpecs() throws DataSourceReadException {
        return KeySetSpec.EMPTY_KEY_SET_SPEC_ARRAY;
    }

    @Override
    public void deleteAllKeys() throws DataSourceWriteException {
    }

    @Override
    public void writeKeys(Set<String> keyIds) throws DataSourceWriteException {
    }

    @Override
    public DataSourceBackendSourceSystem getSourceSystem() {
        return DataSourceBackendSourceSystem.getInstance(this.getId());
    }
}

