/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.protempa.Algorithm;
import org.protempa.AlgorithmArguments;
import org.protempa.AlgorithmInitializationException;
import org.protempa.AlgorithmParameter;
import org.protempa.AlgorithmProcessingException;
import org.protempa.Algorithms;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueType;

public abstract class AbstractAlgorithm
implements Algorithm {
    private static final long serialVersionUID = 6566132392629105106L;
    private ValueType inValueType;
    private String id;
    private AlgorithmParameter[] parameters;
    private final Map<String, AlgorithmParameter> parametersMap;
    private int advanceRowSkipEnd;
    private int minNumVal;
    private int maxNumVal;

    public AbstractAlgorithm(Algorithms algorithms, String id) {
        this.id = AbstractAlgorithm.computeId(algorithms, id, false);
        this.parametersMap = new HashMap<String, AlgorithmParameter>();
        this.advanceRowSkipEnd = -1;
        if (algorithms != null) {
            algorithms.addAlgorithm(this);
        }
        this.minNumVal = 1;
        this.maxNumVal = Integer.MAX_VALUE;
    }

    private static String computeId(Algorithms algorithms, String id, boolean fail) {
        if (id == null || id.length() == 0) {
            return algorithms.getNextAlgorithmObjectId();
        }
        if (!algorithms.isUniqueAlgorithmObjectId(id)) {
            if (fail) {
                throw new IllegalArgumentException("id " + id + " is not unique.");
            }
            return algorithms.getNextAlgorithmObjectId();
        }
        return id;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public final void setMinimumNumberOfValues(int val) {
        if (val == 0) {
            throw new IllegalArgumentException("val cannot be 0");
        }
        this.minNumVal = val;
    }

    @Override
    public final int getMinimumNumberOfValues() {
        return this.minNumVal;
    }

    public final void setMaximumNumberOfValues(int val) {
        if (val < 1) {
            throw new IllegalArgumentException("val cannot be < 1");
        }
        this.maxNumVal = val;
    }

    @Override
    public final int getMaximumNumberOfValues() {
        return this.maxNumVal;
    }

    @Override
    public void close() {
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {
            ProtempaUtil.logger().log(Level.SEVERE, "Could not finalize " + this.toString(), e);
        }
    }

    @Override
    public final ValueType getInValueType() {
        return this.inValueType;
    }

    public final void setInValueType(ValueType inValueType) {
        this.inValueType = inValueType;
    }

    public void setParameters(AlgorithmParameter[] parameters) {
        this.parameters = parameters;
        this.parametersMap.clear();
        if (parameters != null) {
            for (AlgorithmParameter p : parameters) {
                this.parametersMap.put(p.getName(), p);
            }
        }
    }

    @Override
    public AlgorithmParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public AlgorithmParameter parameter(String name) {
        return this.parametersMap.get(name);
    }

    @Override
    public Filter createDataSourceConstraint() {
        return null;
    }

    protected void setAdvanceRowSkipEnd(int advanceRowSkipEnd) {
        this.advanceRowSkipEnd = advanceRowSkipEnd;
    }

    @Override
    public int getAdvanceRowSkipEnd() {
        return this.advanceRowSkipEnd;
    }

    public String toString() {
        return "Algorithm " + this.getId();
    }

    @Override
    public void initialize(AlgorithmArguments arguments) throws AlgorithmInitializationException {
    }

    @Override
    public abstract Value compute(Segment<PrimitiveParameter> var1, AlgorithmArguments var2) throws AlgorithmProcessingException;
}

