/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import org.protempa.BackendCloseException;
import org.protempa.ProtempaEventListener;
import org.protempa.ProtempaUtil;
import org.protempa.Source;
import org.protempa.SourceCloseException;
import org.protempa.SourceClosedUnexpectedlyEvent;
import org.protempa.SourceListener;
import org.protempa.SourceUpdatedEvent;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendUpdatedEvent;
import org.protempa.backend.UnrecoverableBackendErrorEvent;

public abstract class AbstractSource<S extends SourceUpdatedEvent, B extends Backend<T>, E extends SourceUpdatedEvent, T extends BackendUpdatedEvent>
implements Source<S, B, T> {
    private final List<SourceListener<S>> listenerList;
    private List<? extends ProtempaEventListener> eventListeners;
    private final B[] backends;
    private boolean closed;

    AbstractSource(B[] backends) {
        assert (backends != null) : "backends cannot be null";
        ProtempaUtil.checkArrayForNullElement(backends, "backends");
        ProtempaUtil.checkArrayForDuplicates(backends, "backends");
        this.listenerList = new ArrayList<SourceListener<S>>();
        for (B backend : this.backends = (Backend[])backends.clone()) {
            backend.addBackendListener(this);
        }
    }

    @Override
    public void setEventListeners(List<? extends ProtempaEventListener> eventListeners) {
        this.eventListeners = eventListeners;
        for (B backend : this.backends) {
            backend.setEventListeners(eventListeners);
        }
    }

    @Override
    public final B[] getBackends() {
        return (Backend[])this.backends.clone();
    }

    @Override
    public final void addSourceListener(SourceListener<S> listener) {
        if (listener != null) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public final void removeSourceListener(SourceListener<S> listener) {
        this.listenerList.remove(listener);
    }

    protected void fireSourceUpdated(S e) {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            this.listenerList.get(i).sourceUpdated(e);
        }
    }

    protected void fireClosedUnexpectedly(SourceClosedUnexpectedlyEvent<S, B, T> e) {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            this.listenerList.get(i).closedUnexpectedly(e);
        }
    }

    @Override
    public void close() throws SourceCloseException {
        for (B backend : this.backends) {
            backend.removeBackendListener(this);
        }
        ArrayList<BackendCloseException> exceptions = new ArrayList<BackendCloseException>();
        for (B backend : this.backends) {
            try {
                backend.close();
            }
            catch (BackendCloseException ex) {
                exceptions.add(ex);
            }
            catch (Error | RuntimeException ex) {
                exceptions.add(new BackendCloseException(ex));
            }
        }
        if (!exceptions.isEmpty()) {
            throw new SourceCloseException(exceptions.toArray(new BackendCloseException[exceptions.size()]));
        }
        this.closed = true;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void unrecoverableErrorOccurred(UnrecoverableBackendErrorEvent e) {
        try {
            this.close();
        }
        catch (SourceCloseException sourceCloseException) {
            // empty catch block
        }
        this.fireClosedUnexpectedly(new SourceClosedUnexpectedlyEvent(this));
    }
}

