/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.Algorithm;
import org.protempa.AlgorithmParameter;
import org.protempa.LowLevelAbstractionValueDefinition;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;

public final class AlgorithmArguments
implements Serializable {
    private static final long serialVersionUID = 3993361731381010295L;
    private final Algorithm algorithm;
    private final Map<String, Value> parameterValues;
    private final Map<String, ValueComparator> parameterValueComps;

    AlgorithmArguments(Algorithm algorithm, LowLevelAbstractionValueDefinition def) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm cannot be null");
        }
        this.algorithm = algorithm;
        this.parameterValues = new HashMap<String, Value>();
        this.parameterValueComps = new HashMap<String, ValueComparator>();
        for (AlgorithmParameter d : algorithm.getParameters()) {
            String name = d.getName();
            this.setArgument(name, def.getParameterComp(name), def.getParameterValue(name));
        }
    }

    private void setArgument(String name, ValueComparator comp, Value value) {
        if (name != null && value != null && this.algorithm.parameter(name) != null && this.algorithm.parameter(name).getValueType().isInstance(value) && this.algorithm.parameter(name).hasComparator(comp)) {
            this.parameterValues.put(name, value);
            this.parameterValueComps.put(name, comp);
        }
    }

    public Value value(String name) {
        return this.parameterValues.get(name);
    }

    public ValueComparator valueComp(String name) {
        return this.parameterValueComps.get(name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

