/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.collections.CompositeList;

public class DataSourceResultMap<P>
implements Map<String, List<P>> {
    private final List<? extends Map<String, List<P>>> maps;

    public DataSourceResultMap(List<? extends Map<String, List<P>>> maps) {
        this.maps = maps != null ? new ArrayList<Map<String, List<P>>>(maps) : Collections.emptyList();
    }

    @Override
    public int size() {
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, List<P>> map : this.maps) {
            keys.addAll(map.keySet());
        }
        return keys.size();
    }

    @Override
    public boolean isEmpty() {
        Map<String, List<P>> map;
        boolean result = true;
        Iterator<Map<String, List<P>>> iterator = this.maps.iterator();
        while (iterator.hasNext() && (result = (map = iterator.next()).isEmpty())) {
        }
        return result;
    }

    @Override
    public boolean containsKey(Object o) {
        Map<String, List<P>> map;
        boolean result = false;
        Iterator<Map<String, List<P>>> iterator = this.maps.iterator();
        while (iterator.hasNext() && !(result = (map = iterator.next()).containsKey(o))) {
        }
        return result;
    }

    @Override
    public boolean containsValue(Object o) {
        Map<String, List<P>> map;
        boolean result = false;
        Iterator<Map<String, List<P>>> iterator = this.maps.iterator();
        while (iterator.hasNext() && !(result = (map = iterator.next()).containsValue(o))) {
        }
        return result;
    }

    @Override
    public List<P> get(Object o) {
        ArrayList<List<P>> lists = null;
        for (Map<String, List<P>> map : this.maps) {
            List<P> list = map.get(o);
            if (list == null) continue;
            if (lists == null) {
                lists = new ArrayList<List<P>>(this.maps.size());
            }
            lists.add(list);
        }
        if (lists == null) {
            return null;
        }
        return Collections.unmodifiableList(new CompositeList(lists));
    }

    @Override
    public List<P> put(String k, List<P> v) {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public List<P> remove(Object o) {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<P>> map) {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This map is immutable");
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (Map<String, List<P>> map : this.maps) {
            result.addAll(map.keySet());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<Map.Entry<String, List<P>>> entrySet() {
        HashMap<String, CompositeList> result = new HashMap<String, CompositeList>();
        if (!this.maps.isEmpty()) {
            int n = this.maps.size();
            for (int i = 0; i < n; ++i) {
                for (Map.Entry<String, List<P>> me : this.maps.get(i).entrySet()) {
                    String key = me.getKey();
                    CompositeList vals = (CompositeList)result.get(key);
                    if (vals == null) {
                        vals = new CompositeList();
                        result.put(key, vals);
                    }
                    vals.addList(me.getValue());
                }
            }
        }
        return Collections.unmodifiableSet(result.entrySet());
    }

    @Override
    public Collection<List<P>> values() {
        HashMap<String, CompositeList> result = new HashMap<String, CompositeList>();
        if (!this.maps.isEmpty()) {
            int n = this.maps.size();
            for (int i = 0; i < n; ++i) {
                for (Map.Entry<String, List<P>> me : this.maps.get(i).entrySet()) {
                    String key = me.getKey();
                    CompositeList vals = (CompositeList)result.get(key);
                    if (vals == null) {
                        vals = new CompositeList();
                        result.put(key, vals);
                    }
                    vals.addList(me.getValue());
                }
            }
        }
        return Collections.unmodifiableCollection(result.values());
    }
}

