/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamerProcessor;
import org.protempa.UniqueIdPair;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;

final class RefDataStreamerProcessor
extends DataStreamerProcessor<UniqueIdPair> {
    private final Map<UniqueId, Proposition> uniqueIdToPropositions;
    private final ReferenceAdder adder = new ReferenceAdder();

    RefDataStreamerProcessor() {
        this.uniqueIdToPropositions = new HashMap<UniqueId, Proposition>();
    }

    void setPropositions(List<? extends Proposition> propositions) {
        assert (propositions != null) : "propositions cannot be null";
        for (Proposition proposition : propositions) {
            assert (proposition != null) : "proposition cannot be null";
            this.uniqueIdToPropositions.put(proposition.getUniqueId(), proposition);
        }
    }

    void clear() {
        this.uniqueIdToPropositions.clear();
    }

    @Override
    protected void fireKeyCompleted(String keyId, List<UniqueIdPair> data) throws DataSourceReadException {
        assert (keyId != null) : "keyId cannot be null";
        assert (data != null) : "data cannot be null";
        assert (this.getKeyId() == null || keyId.equals(this.getKeyId())) : "incompatible keyId: expected " + this.getKeyId() + " but got " + keyId;
        for (UniqueIdPair pair : data) {
            Proposition prop = this.getProposition(pair.getProposition());
            if (prop != null) {
                this.adder.setParameters(pair.getReferenceName(), pair.getReference());
                prop.accept(this.adder);
                continue;
            }
            throw new DataSourceReadException("Can't find left-hand-side of reference: keyId=" + keyId + "; references: " + pair);
        }
    }

    private Proposition getProposition(UniqueId uniqueId) {
        return this.uniqueIdToPropositions.get(uniqueId);
    }

    private static class ReferenceAdder
    extends AbstractPropositionVisitor {
        private String referenceName;
        private UniqueId reference;

        private ReferenceAdder() {
        }

        @Override
        public void visit(AbstractParameter abstractParameter) {
            throw new AssertionError((Object)("Should not have been passed abstract parameter: " + abstractParameter));
        }

        @Override
        public void visit(Event event) {
            event.addReference(this.referenceName, this.reference);
        }

        @Override
        public void visit(PrimitiveParameter primitiveParameter) {
            primitiveParameter.addReference(this.referenceName, this.reference);
        }

        @Override
        public void visit(Constant constant) {
            constant.addReference(this.referenceName, this.reference);
        }

        @Override
        public void visit(Context context) {
            context.addReference(this.referenceName, this.reference);
        }

        void setParameters(String referenceName, UniqueId reference) {
            this.referenceName = referenceName;
            this.reference = reference;
        }
    }
}

