/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protempa.AbstractSource;
import org.protempa.SourceCloseException;
import org.protempa.Term;
import org.protempa.TermSource;
import org.protempa.TermSourceReadException;
import org.protempa.TermSourceUpdatedEvent;
import org.protempa.backend.Backend;
import org.protempa.backend.TermSourceBackendUpdatedEvent;
import org.protempa.backend.tsb.TermSourceBackend;

public final class TermSourceImpl
extends AbstractSource<TermSourceUpdatedEvent, TermSourceBackend, TermSourceUpdatedEvent, TermSourceBackendUpdatedEvent>
implements TermSource {
    private final Set<String> notFoundTerms = new HashSet<String>();

    public TermSourceImpl(TermSourceBackend[] backends) {
        super((Backend[])(backends != null ? backends : new TermSourceBackend[]{}));
    }

    @Override
    public Term readTerm(String id) throws TermSourceReadException {
        Term result = null;
        if (!this.notFoundTerms.contains(id)) {
            if (this.isClosed()) {
                throw new TermSourceReadException("Term source already closed!");
            }
            for (TermSourceBackend backend : (TermSourceBackend[])this.getBackends()) {
                result = backend.readTerm(id);
                if (result == null) continue;
                return result;
            }
            this.notFoundTerms.add(id);
        }
        return result;
    }

    @Override
    public List<String> getTermSubsumption(String termId) throws TermSourceReadException {
        List<String> result = null;
        if (this.isClosed()) {
            throw new TermSourceReadException("Term source already closed!");
        }
        for (TermSourceBackend backend : (TermSourceBackend[])this.getBackends()) {
            result = backend.getSubsumption(termId);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public void close() throws SourceCloseException {
        this.clear();
        super.close();
    }

    private void fireTermSourceUpdated() {
        this.fireSourceUpdated(new TermSourceUpdatedEvent(this));
    }

    @Override
    public void backendUpdated(TermSourceBackendUpdatedEvent event) {
        this.clear();
        this.fireTermSourceUpdated();
    }

    @Override
    public void clear() {
    }
}

