/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.cli;

import org.apache.commons.lang3.StringUtils;
import org.protempa.AbstractPropositionDefinitionVisitor;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.ConstantDefinition;
import org.protempa.ContextDefinition;
import org.protempa.EventDefinition;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.PrimitiveParameterDefinition;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.ReferenceDefinition;
import org.protempa.SequentialTemporalPatternDefinition;
import org.protempa.SliceDefinition;

class PropositionDefinitionPrinter
extends AbstractPropositionDefinitionVisitor {
    PropositionDefinitionPrinter() {
    }

    @Override
    public void visit(EventDefinition eventDefinition) {
        System.out.println("Event definition " + eventDefinition.getId());
        this.printCommon(eventDefinition);
    }

    @Override
    public void visit(ContextDefinition contextDefinition) {
        System.out.println("Context definition " + contextDefinition.getId());
        this.printCommon(contextDefinition);
    }

    @Override
    public void visit(HighLevelAbstractionDefinition highLevelAbstractionDefinition) {
        System.out.println("High level abstraction definition " + highLevelAbstractionDefinition.getId());
        this.printCommon(highLevelAbstractionDefinition);
    }

    @Override
    public void visit(LowLevelAbstractionDefinition lowLevelAbstractionDefinition) {
        System.out.println("Low level abstraction definition " + lowLevelAbstractionDefinition.getId());
        System.out.println("\tvalue: " + (Object)((Object)lowLevelAbstractionDefinition.getValueType()));
        this.printCommon(lowLevelAbstractionDefinition);
    }

    @Override
    public void visit(CompoundLowLevelAbstractionDefinition compoundLowLevelAbstractionDefinition) {
        System.out.println("Extended low level abstraction definition " + compoundLowLevelAbstractionDefinition.getId());
        this.printCommon(compoundLowLevelAbstractionDefinition);
    }

    @Override
    public void visit(PrimitiveParameterDefinition primitiveParameterDefinition) {
        System.out.println("Primitive parameter definition " + primitiveParameterDefinition.getId());
        System.out.println("\tvalue: " + (Object)((Object)primitiveParameterDefinition.getValueType()));
        System.out.println("\tunits: " + primitiveParameterDefinition.getUnits());
        this.printCommon(primitiveParameterDefinition);
    }

    @Override
    public void visit(SliceDefinition sliceAbstractionDefinition) {
        System.out.println("Slice abstraction definition " + sliceAbstractionDefinition.getId());
        this.printCommon(sliceAbstractionDefinition);
    }

    @Override
    public void visit(ConstantDefinition constantDefinition) {
        System.out.println("Constant definition " + constantDefinition.getId());
        this.printCommon(constantDefinition);
    }

    @Override
    public void visit(SequentialTemporalPatternDefinition pairDefinition) {
        System.out.println("Pair definition " + pairDefinition.getId());
        this.printCommon(pairDefinition);
    }

    private void printCommon(PropositionDefinition propositionDefinition) {
        System.out.println("\tpropositionId: " + propositionDefinition.getPropositionId());
        this.printDisplayNames(propositionDefinition);
        System.out.println("\tsolid: " + propositionDefinition.isSolid());
        System.out.println("\tconcatenable: " + propositionDefinition.isConcatenable());
        this.printProperties(propositionDefinition);
        this.printReferences(propositionDefinition);
        this.printTerms(propositionDefinition);
    }

    private void printReferences(PropositionDefinition propositionDefinition) {
        ReferenceDefinition[] refDefs = propositionDefinition.getReferenceDefinitions();
        if (refDefs.length == 0) {
            System.out.println("\tNo references");
        } else {
            System.out.println("\t" + refDefs.length + " references:");
            for (ReferenceDefinition refDef : refDefs) {
                this.printReference(refDef);
            }
        }
    }

    private void printReference(ReferenceDefinition refDef) {
        System.out.print("\t\t" + refDef.getId() + ": ");
        System.out.println(StringUtils.join((Object[])refDef.getPropositionIds(), (String)", "));
    }

    private void printProperties(PropositionDefinition propositionDefinition) {
        PropertyDefinition[] propDefs = propositionDefinition.getPropertyDefinitions();
        if (propDefs.length == 0) {
            System.out.println("\tNo properties");
        } else {
            System.out.println("\t" + propDefs.length + " properties:");
            for (PropertyDefinition propDef : propDefs) {
                this.printProperty(propDef);
            }
        }
    }

    private void printProperty(PropertyDefinition propDef) {
        String valueSetId = propDef.getValueSetId();
        if (valueSetId != null) {
            valueSetId = ", " + valueSetId;
        }
        System.out.println("\t\t" + propDef.getDisplayName() + ": " + (Object)((Object)propDef.getValueType()) + valueSetId);
    }

    private void printDisplayNames(PropositionDefinition propositionDefinition) {
        System.out.println("\tDisplay name: " + propositionDefinition.getDisplayName());
        System.out.println("\tAbbreviated display name: " + propositionDefinition.getAbbreviatedDisplayName());
    }

    private void printTerms(PropositionDefinition propositionDefinition) {
        System.out.println("\tAssociated terms: " + StringUtils.join((Object[])propositionDefinition.getTermIds(), (String)", "));
    }
}

