/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.ProtempaUtil;
import org.protempa.dest.table.AbstractTableColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkValidationFailedException;
import org.protempa.dest.table.TableColumnSpecValidationFailedException;
import org.protempa.dest.table.TabularWriter;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.dest.table.Util;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public final class CountColumnSpec
extends AbstractTableColumnSpec {
    private final String columnNameOverride;
    private final Link[] links;
    private final boolean countUnique;

    public CountColumnSpec(Link[] links) {
        this(null, links, false);
    }

    public CountColumnSpec(String columnNameOverride, Link[] links, boolean countUnique) {
        ProtempaUtil.checkArray(links, "links");
        this.links = (Link[])links.clone();
        this.columnNameOverride = columnNameOverride;
        this.countUnique = countUnique;
    }

    @Override
    public String[] columnNames(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        StringBuilder builder = new StringBuilder();
        if (this.columnNameOverride != null) {
            builder.append(this.columnNameOverride);
        } else {
            if (this.countUnique) {
                builder.append("countUnique(");
            } else {
                builder.append("count(");
            }
            builder.append(this.generateLinksHeaderString(this.links));
            builder.append(')');
        }
        return new String[]{builder.toString()};
    }

    @Override
    public void columnValues(String key, Proposition proposition, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache, TabularWriter writer) throws TabularWriterException {
        Logger logger = Util.logger();
        List<Proposition> props = this.traverseLinks(this.links, proposition, forwardDerivations, backwardDerivations, references, ksCache);
        if (this.countUnique) {
            HashSet<String> result = new HashSet<String>();
            for (Proposition p : props) {
                String pId = p.getId();
                logger.log(Level.FINEST, "Looking at proposition id {0}", pId);
                if (!result.add(pId)) continue;
                logger.log(Level.FINEST, "Adding to count: {0}", pId);
            }
            writer.writeString("" + result.size());
        } else {
            writer.writeString("" + props.size());
        }
    }

    @Override
    public void validate(KnowledgeSource knowledgeSource) throws TableColumnSpecValidationFailedException, KnowledgeSourceReadException {
        int i = 1;
        for (Link link : this.links) {
            try {
                link.validate(knowledgeSource);
            }
            catch (LinkValidationFailedException ex) {
                throw new TableColumnSpecValidationFailedException("Validation of link " + i + " failed", ex);
            }
            ++i;
        }
    }

    public String getColumnNameOverride() {
        return this.columnNameOverride;
    }

    public Link[] getLinks() {
        return this.links;
    }

    public boolean isCountUnique() {
        return this.countUnique;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnNameOverride == null ? 0 : this.columnNameOverride.hashCode());
        result = 31 * result + (this.countUnique ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.links);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CountColumnSpec other = (CountColumnSpec)obj;
        if (this.columnNameOverride == null ? other.columnNameOverride != null : !this.columnNameOverride.equals(other.columnNameOverride)) {
            return false;
        }
        if (this.countUnique != other.countUnique) {
            return false;
        }
        return Arrays.equals(this.links, other.links);
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        HashSet result = new HashSet();
        for (Link link : this.links) {
            inPropIds = link.getInferredPropositionIds(knowledgeSource, inPropIds);
            org.arp.javautil.arrays.Arrays.addAll(result, (Object[][])new String[][]{inPropIds});
        }
        return result.toArray(new String[result.size()]);
    }
}

