/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.ProtempaUtil;
import org.protempa.dest.table.AbstractTableColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkValidationFailedException;
import org.protempa.dest.table.TableColumnSpecValidationFailedException;
import org.protempa.dest.table.TabularWriter;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.dest.table.Util;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.PropositionUtil;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.comparator.AllPropositionIntervalComparator;
import org.protempa.proposition.value.Unit;

public final class DistanceBetweenColumnSpec
extends AbstractTableColumnSpec {
    private static final Comparator<Proposition> comp = new AllPropositionIntervalComparator();
    private final Link[] links;
    private final String columnNamePrefixOverride;
    private final Unit units;

    public DistanceBetweenColumnSpec(Link[] links) {
        this(null, links);
    }

    public DistanceBetweenColumnSpec(String columnNamePrefixOverride, Link[] links) {
        this(columnNamePrefixOverride, links, null);
    }

    public DistanceBetweenColumnSpec(String columnNamePrefixOverride, Link[] links, Unit units) {
        if (links == null) {
            this.links = Util.EMPTY_LINK_ARRAY;
        } else {
            ProtempaUtil.checkArrayForNullElement(links, "links");
            this.links = (Link[])links.clone();
        }
        this.columnNamePrefixOverride = columnNamePrefixOverride;
        this.units = units;
    }

    @Override
    public String[] columnNames(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        String headerString = this.columnNamePrefixOverride != null ? this.columnNamePrefixOverride : this.generateLinksHeaderString(this.links) + "_lengthBetween";
        return new String[]{headerString};
    }

    @Override
    public void columnValues(String key, Proposition proposition, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache, TabularWriter writer) throws TabularWriterException {
        Logger logger = Util.logger();
        List<Proposition> propositions = this.traverseLinks(this.links, proposition, forwardDerivations, backwardDerivations, references, ksCache);
        Collections.sort(propositions, comp);
        int size = propositions.size();
        if (size > 2) {
            logger.log(Level.WARNING, "There should be two or less propositions but there are {0}", size);
        }
        if (size < 2) {
            writer.writeNull();
            return;
        }
        Iterator<Proposition> itr = propositions.iterator();
        TemporalProposition first = null;
        TemporalProposition second = null;
        Proposition tmpFirst = itr.next();
        if (tmpFirst instanceof TemporalProposition) {
            first = (TemporalProposition)tmpFirst;
        } else {
            logger.log(Level.WARNING, "The first proposition is not temporal: ", tmpFirst.getId());
        }
        Proposition tmpSecond = itr.next();
        if (tmpSecond instanceof TemporalProposition) {
            second = (TemporalProposition)tmpSecond;
        } else {
            logger.log(Level.WARNING, "The second proposition is not temporal: ", tmpSecond.getId());
        }
        String distance = PropositionUtil.distanceBetweenFormattedShort(first, second, this.units);
        writer.writeString(distance);
    }

    @Override
    public void validate(KnowledgeSource knowledgeSource) throws TableColumnSpecValidationFailedException, KnowledgeSourceReadException {
        int i = 1;
        for (Link link : this.links) {
            try {
                link.validate(knowledgeSource);
            }
            catch (LinkValidationFailedException ex) {
                throw new TableColumnSpecValidationFailedException("Validation of link " + i + " failed", ex);
            }
            ++i;
        }
    }

    public Link[] getLinks() {
        return this.links;
    }

    public String getColumnNamePrefixOverride() {
        return this.columnNamePrefixOverride;
    }

    public Unit getUnits() {
        return this.units;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnNamePrefixOverride == null ? 0 : this.columnNamePrefixOverride.hashCode());
        result = 31 * result + Arrays.hashCode(this.links);
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistanceBetweenColumnSpec other = (DistanceBetweenColumnSpec)obj;
        if (this.columnNamePrefixOverride == null ? other.columnNamePrefixOverride != null : !this.columnNamePrefixOverride.equals(other.columnNamePrefixOverride)) {
            return false;
        }
        if (!Arrays.equals(this.links, other.links)) {
            return false;
        }
        return !(this.units == null ? other.units != null : !this.units.equals(other.units));
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        HashSet result = new HashSet();
        for (Link link : this.links) {
            inPropIds = link.getInferredPropositionIds(knowledgeSource, inPropIds);
            org.arp.javautil.arrays.Arrays.addAll(result, (Object[][])new String[][]{inPropIds});
        }
        return result.toArray(new String[result.size()]);
    }
}

