/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.ProtempaException;
import org.protempa.proposition.TemporalParameter;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.visitor.PropositionCheckedVisitor;
import org.protempa.proposition.visitor.PropositionVisitor;

public final class PrimitiveParameter
extends TemporalParameter
implements Serializable {
    private static final long serialVersionUID = 693807976086426915L;

    public PrimitiveParameter(String id, UniqueId uniqueId) {
        super(id, uniqueId);
    }

    public Long getPosition() {
        Interval interval = this.getInterval();
        if (interval != null) {
            return interval.getMinStart();
        }
        return null;
    }

    public void setPosition(Long pos) {
        Interval interval = this.getInterval();
        if (interval != null) {
            this.resetInterval(pos, interval.getStartGranularity());
        } else {
            this.resetInterval(pos, null);
        }
    }

    public Granularity getGranularity() {
        Interval interval = this.getInterval();
        if (interval != null) {
            return interval.getStartGranularity();
        }
        return null;
    }

    public void setGranularity(Granularity granularity) {
        Interval interval = this.getInterval();
        if (interval != null) {
            this.resetInterval(interval.getMinStart(), granularity);
        } else {
            this.resetInterval(null, granularity);
        }
    }

    private void resetInterval(Long timestamp, Granularity granularity) {
        this.setInterval(INTERVAL_FACTORY.getInstance(timestamp, granularity, timestamp, granularity));
    }

    public String getPositionFormattedLong() {
        return this.getStartFormattedLong();
    }

    public String getPositionFormattedMedium() {
        return this.getStartFormattedMedium();
    }

    public String getPositionFormattedShort() {
        return this.getStartFormattedShort();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).toString();
    }

    @Override
    public boolean isEqual(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveParameter)) {
            return false;
        }
        PrimitiveParameter p = (PrimitiveParameter)o;
        return super.isEqual(p);
    }

    @Override
    public void accept(PropositionVisitor propositionVisitor) {
        propositionVisitor.visit(this);
    }

    @Override
    public void acceptChecked(PropositionCheckedVisitor propositionCheckedVisitor) throws ProtempaException {
        propositionCheckedVisitor.visit(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeAbstractProposition(s);
        s.writeObject(this.getPosition());
        s.writeObject(this.getGranularity());
        this.writeTemporalParameter(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readAbstractProposition(s);
        this.setPosition((Long)s.readObject());
        this.setGranularity((Granularity)s.readObject());
        this.readTemporalParameter(s);
    }
}

