/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.comparator.TemporalPropositionIntervalComparator;
import org.protempa.proposition.visitor.PropositionVisitable;
import org.protempa.proposition.visitor.PropositionVisitor;

public final class Sequence<T extends TemporalProposition>
implements List<T>,
RandomAccess,
PropositionVisitable {
    private static final long serialVersionUID = -6908483602466100689L;
    private static final Comparator<TemporalProposition> TEMP_PROP_COMP = new TemporalPropositionIntervalComparator();
    private final Set<String> propIds;
    private final List<T> l;
    private boolean sortNeeded;

    public Sequence(String propId) {
        this(propId, null);
    }

    public Sequence(String propId, int initialCapacity) {
        this.l = new ArrayList<T>(initialCapacity);
        this.propIds = Collections.singleton(propId);
    }

    public Sequence(Set<String> propIds) {
        this(propIds, null);
    }

    public Sequence(String propId, List<T> data) {
        this(Collections.singleton(propId), data);
    }

    public Sequence(Set<String> propIds, List<T> data) {
        this.l = data != null ? new ArrayList<T>(data) : new ArrayList<T>();
        this.propIds = propIds;
        if (this.l.size() > 1) {
            this.sortNeeded = true;
        }
    }

    public Set<String> getPropositionIds() {
        return this.propIds;
    }

    @Override
    public boolean add(T o) {
        int lsize;
        if (!this.sortNeeded && (lsize = this.l.size()) > 0 && TEMP_PROP_COMP.compare((TemporalProposition)this.l.get(lsize - 1), (TemporalProposition)o) > 0) {
            this.sortNeeded = true;
        }
        if (o == null) {
            throw new NullPointerException();
        }
        return this.l.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.sortNeeded = true;
        for (TemporalProposition elt : c) {
            if (this.add((T)elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        this.sortIfNeeded();
        return (T)((TemporalProposition)this.l.get(index));
    }

    @Override
    public int indexOf(Object elem) {
        this.sortIfNeeded();
        return Collections.binarySearch(this.l, (TemporalProposition)elem, TEMP_PROP_COMP);
    }

    public String toString() {
        this.sortIfNeeded();
        return (this.propIds != null ? this.propIds.toString() + "; " : "") + this.l;
    }

    @Override
    public int size() {
        return this.l.size();
    }

    @Override
    public boolean isEmpty() {
        return this.l.isEmpty();
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.l.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.indexOf(arg0) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        Iterator<?> itr = arg0.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        this.sortIfNeeded();
        return this.l.iterator();
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.indexOf(elem);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.sortIfNeeded();
        return this.l.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        this.sortIfNeeded();
        return this.l.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        int i = this.indexOf(arg0);
        if (i >= 0) {
            return this.remove(i) != null;
        }
        return false;
    }

    @Override
    public T remove(int arg0) {
        this.sortIfNeeded();
        return (T)((TemporalProposition)this.l.remove(arg0));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> itr = this.iterator();
        while (itr.hasNext()) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public T set(int arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        this.sortIfNeeded();
        return this.l.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        this.sortIfNeeded();
        return this.l.toArray();
    }

    @Override
    public <E> E[] toArray(E[] arg0) {
        this.sortIfNeeded();
        return this.l.toArray(arg0);
    }

    private void sortIfNeeded() {
        if (this.sortNeeded) {
            if (this.l.size() > 1) {
                Collections.sort(this.l, TEMP_PROP_COMP);
            }
            this.sortNeeded = false;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)obj;
        return this.l.equals(other.l) && (this.propIds == other.propIds || this.propIds != null && this.propIds.equals(other.propIds));
    }

    @Override
    public int hashCode() {
        int result = this.l.hashCode();
        if (this.propIds != null) {
            result = 37 * result + this.propIds.hashCode();
        }
        return result;
    }

    @Override
    public void accept(PropositionVisitor propositionVisitor) {
        for (Proposition prop : this) {
            prop.accept(propositionVisitor);
        }
    }
}

