/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NumberValueBuilder;
import org.protempa.proposition.value.NumericalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public final class NumberValue
implements NumericalValue,
Comparable<NumberValue>,
Serializable {
    private static final long serialVersionUID = 266750924747111671L;
    private static final Map<BigDecimal, NumberValue> cache = new ReferenceMap();
    private BigDecimal num;
    private volatile transient int hashCode;

    public static NumberValue parse(String str) {
        return (NumberValue)ValueType.NUMBERVALUE.parse(str);
    }

    public static NumberValue getInstance(double num) {
        return NumberValue.getInstance(BigDecimal.valueOf(num));
    }

    public static NumberValue getInstance(long num) {
        return NumberValue.getInstance(BigDecimal.valueOf(num));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberValue getInstance(BigDecimal num) {
        NumberValue result;
        if (num != null) {
            Map<BigDecimal, NumberValue> map = cache;
            synchronized (map) {
                result = cache.get(num);
                if (result == null) {
                    result = new NumberValue(num);
                    cache.put(num, result);
                }
            }
        } else {
            result = NumberValue.getInstance(BigDecimal.ZERO);
        }
        return result;
    }

    public NumberValue(long num) {
        this(BigDecimal.valueOf(num));
    }

    public NumberValue(double num) {
        this(BigDecimal.valueOf(num));
    }

    public NumberValue(BigDecimal num) {
        this.init(num);
    }

    private void init(BigDecimal num) {
        this.num = num == null ? BigDecimal.ZERO : num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumberValue replace() {
        NumberValue result;
        Map<BigDecimal, NumberValue> map = cache;
        synchronized (map) {
            result = cache.get(this.num);
        }
        if (result != null) {
            return result;
        }
        return this;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.num.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberValue other = (NumberValue)obj;
        return this.num == other.num || this.num.equals(other.num);
    }

    @Override
    public int compareTo(NumberValue o) {
        return this.num.compareTo(o.num);
    }

    @Override
    public String getFormatted() {
        return this.num.toString();
    }

    @Override
    public String format(Format format) {
        if (format == null) {
            return this.getFormatted();
        }
        return format.format(this.num);
    }

    @Override
    public ValueType getType() {
        return ValueType.NUMBERVALUE;
    }

    @Override
    public double doubleValue() {
        return this.num.doubleValue();
    }

    public long longValue() {
        return this.num.longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.num;
    }

    @Override
    public ValueComparator compare(Value o) {
        if (o == null) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        switch (o.getType()) {
            case NUMBERVALUE: {
                NumberValue other = (NumberValue)o;
                int comp = this.compareTo(other);
                return comp > 0 ? ValueComparator.GREATER_THAN : (comp < 0 ? ValueComparator.LESS_THAN : ValueComparator.EQUAL_TO);
            }
            case INEQUALITYNUMBERVALUE: {
                InequalityNumberValue other2 = (InequalityNumberValue)o;
                int comp2 = this.num.compareTo((BigDecimal)other2.getNumber());
                switch (other2.getComparator()) {
                    case EQUAL_TO: {
                        return comp2 > 0 ? ValueComparator.GREATER_THAN : (comp2 < 0 ? ValueComparator.LESS_THAN : ValueComparator.EQUAL_TO);
                    }
                    case GREATER_THAN: {
                        return comp2 <= 0 ? ValueComparator.LESS_THAN : ValueComparator.UNKNOWN;
                    }
                }
                return comp2 >= 0 ? ValueComparator.GREATER_THAN : ValueComparator.UNKNOWN;
            }
            case VALUELIST: {
                ValueList vl = (ValueList)o;
                return this.equals(vl) ? ValueComparator.EQUAL_TO : ValueComparator.NOT_EQUAL_TO;
            }
        }
        return ValueComparator.NOT_EQUAL_TO;
    }

    @Override
    public Number getNumber() {
        return this.num;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.num);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        BigDecimal tmpNum = (BigDecimal)s.readObject();
        this.init(tmpNum);
        if (!cache.containsKey(tmpNum)) {
            cache.put(tmpNum, this);
        }
    }

    @Override
    public NumberValue getNumberValue() {
        return this;
    }

    @Override
    public NumberValueBuilder asBuilder() {
        return new NumberValueBuilder(this);
    }
}

