/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.OrderedValue;
import org.protempa.proposition.value.OrdinalValueBuilder;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public final class OrdinalValue
implements OrderedValue,
Serializable {
    private static final long serialVersionUID = -1605459658420554439L;
    private String val;
    private int index;
    private volatile transient int hashCode;

    OrdinalValue(String value, int index) {
        this.val = value;
        this.index = index;
    }

    @Override
    public OrdinalValue replace() {
        return this;
    }

    @Override
    public String getFormatted() {
        return this.val;
    }

    @Override
    public String format(Format format) {
        if (format == null) {
            return this.getFormatted();
        }
        return format.format(this.val);
    }

    @Override
    public ValueType getType() {
        return ValueType.ORDINALVALUE;
    }

    public String getValue() {
        return this.val;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public ValueComparator compare(Value o) {
        if (o == null) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        switch (o.getType()) {
            case ORDINALVALUE: {
                OrdinalValue other = (OrdinalValue)o;
                if (this.val == null || other.val == null) {
                    return ValueComparator.UNKNOWN;
                }
                int c = this.index - other.index;
                if (c == 0) {
                    return ValueComparator.EQUAL_TO;
                }
                if (c > 0) {
                    return ValueComparator.GREATER_THAN;
                }
                return ValueComparator.LESS_THAN;
            }
            case VALUELIST: {
                ValueList vl = (ValueList)o;
                return this.equals(vl) ? ValueComparator.EQUAL_TO : ValueComparator.NOT_EQUAL_TO;
            }
        }
        return ValueComparator.NOT_EQUAL_TO;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.val);
        hash = 67 * hash + this.index;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrdinalValue other = (OrdinalValue)obj;
        if (!Objects.equals(this.val, other.val)) {
            return false;
        }
        return this.index == other.index;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.val);
        s.writeInt(this.index);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.val = (String)s.readObject();
        this.index = s.readInt();
    }

    @Override
    public OrdinalValueBuilder asBuilder() {
        return new OrdinalValueBuilder(this);
    }
}

