/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.query;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.AlgorithmSource;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.query.And;
import org.protempa.query.Query;
import org.protempa.query.QueryBuildException;
import org.protempa.query.QueryBuilder;
import org.protempa.query.QueryMode;

public class DefaultQueryBuilder
implements QueryBuilder,
Serializable {
    private static final long serialVersionUID = -3920993703423486485L;
    private static final PropositionDefinition[] EMPTY_PROP_DEF_ARRAY = new PropositionDefinition[0];
    private static boolean validatePropositionIds = true;
    private String[] keyIds;
    private Filter filters;
    private String[] propIds;
    private And<String>[] termIds;
    private PropositionDefinition[] propDefs;
    private String name;
    private String username;
    private final PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private QueryMode queryMode;

    public DefaultQueryBuilder() {
        this.propDefs = EMPTY_PROP_DEF_ARRAY;
        this.keyIds = ArrayUtils.EMPTY_STRING_ARRAY;
        this.propIds = ArrayUtils.EMPTY_STRING_ARRAY;
        this.termIds = new And[0];
        this.queryMode = Query.DEFAULT_QUERY_MODE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(QueryMode queryMode) {
        QueryMode old = this.queryMode;
        this.queryMode = queryMode == null ? Query.DEFAULT_QUERY_MODE : queryMode;
        this.changes.firePropertyChange("queryMode", (Object)old, (Object)this.queryMode);
    }

    public final Filter getFilters() {
        return this.filters;
    }

    public final void setFilters(Filter filters) {
        Filter old = this.filters;
        this.filters = filters;
        this.changes.firePropertyChange("filters", old, this.filters);
    }

    public final String[] getKeyIds() {
        return (String[])this.keyIds.clone();
    }

    public final void setKeyIds(String[] keyIds) {
        if (keyIds == null) {
            keyIds = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] old = this.keyIds;
        this.keyIds = (String[])keyIds.clone();
        this.changes.firePropertyChange("keyIds", old, this.keyIds);
    }

    public final String[] getPropositionIds() {
        return (String[])this.propIds.clone();
    }

    public final void setPropositionIds(String[] propIds) {
        String[] old = this.propIds;
        if (propIds == null) {
            this.propIds = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            this.propIds = (String[])propIds.clone();
            ProtempaUtil.internAll(this.propIds);
        }
        this.changes.firePropertyChange("propIds", old, this.propIds);
    }

    public final And<String>[] getTermIds() {
        return (And[])this.termIds.clone();
    }

    public final void setTermIds(And<String>[] termIds) {
        if (termIds == null) {
            termIds = new And[]{};
        }
        And<String>[] old = this.termIds;
        this.termIds = (And[])termIds.clone();
        this.changes.firePropertyChange("termIds", old, this.termIds);
    }

    public final PropositionDefinition[] getPropositionDefinitions() {
        return (PropositionDefinition[])this.propDefs.clone();
    }

    public final void setPropositionDefinitions(PropositionDefinition[] propDefs) {
        if (propDefs == null) {
            propDefs = EMPTY_PROP_DEF_ARRAY;
        }
        PropositionDefinition[] old = this.propDefs;
        this.propDefs = (PropositionDefinition[])propDefs.clone();
        this.changes.firePropertyChange("propositionDefinitions", old, this.propDefs);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public Query build(KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws QueryBuildException {
        if (validatePropositionIds) {
            HashSet<String> userSpecifiedPropIds = new HashSet<String>();
            for (PropositionDefinition propDef : this.propDefs) {
                userSpecifiedPropIds.add(propDef.getId());
            }
            ArrayList<Object> propIdsToTest = new ArrayList<Object>(this.propIds.length);
            for (PropositionDefinition propDef : this.propDefs) {
                for (String propId : propDef.getChildren()) {
                    if (userSpecifiedPropIds.contains(propId)) continue;
                    propIdsToTest.add(propId);
                }
            }
            for (String propId : this.propIds) {
                if (userSpecifiedPropIds.contains(propId)) continue;
                propIdsToTest.add(propId);
            }
            try {
                List<PropositionDefinition> pds = knowledgeSource.readPropositionDefinitions(propIdsToTest.toArray(new String[propIdsToTest.size()]));
                ArrayList<String> actualPropIds = new ArrayList<String>(pds.size());
                for (PropositionDefinition propDef : pds) {
                    actualPropIds.add(propDef.getId());
                }
                propIdsToTest.removeAll(actualPropIds);
                if (!propIdsToTest.isEmpty()) {
                    throw new QueryBuildException("Invalid proposition ids: " + propIdsToTest);
                }
            }
            catch (KnowledgeSourceReadException ex) {
                throw new QueryBuildException("Could not build query", ex);
            }
        }
        return new Query(this.name, this.username, this.keyIds, this.filters, this.propIds, this.termIds, this.propDefs, this.queryMode);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static void setValidatePropositionIds(boolean validatePropositionIdsFlag) {
        validatePropositionIds = validatePropositionIdsFlag;
    }

    public static boolean isValidatePropositionIds() {
        return validatePropositionIds;
    }
}

