/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.util.Iterator;
import org.protempa.graph.DirectedGraph;
import org.protempa.graph.Edge;
import org.protempa.graph.Weight;

final class DirectionalPathConsistency {
    private DirectionalPathConsistency() {
    }

    private static Weight getWeight(int i, int j, Object v1, Object v2, DirectedGraph g, Weight[][] updatedEdges) {
        Edge e;
        Weight w = updatedEdges[i][j];
        if (w == null && (e = g.getEdge(v1, v2)) != null) {
            w = e.getWeight();
        }
        return w;
    }

    static boolean getConsistent(DirectedGraph g) {
        Object[] vertexOrdering = new Object[g.size()];
        int voa = 0;
        Iterator<?> itr = g.iterator();
        while (itr.hasNext()) {
            vertexOrdering[voa] = itr.next();
            ++voa;
        }
        int vol = vertexOrdering.length;
        Weight[][] updatedEdges = new Weight[vol][vol];
        for (int k = vol - 1; k > 1; --k) {
            Object vk = vertexOrdering[k];
            for (int i = 0; i < k; ++i) {
                Object vi = vertexOrdering[i];
                Weight wik = DirectionalPathConsistency.getWeight(i, k, vi, vk, g, updatedEdges);
                if (wik == null) continue;
                Weight wki = DirectionalPathConsistency.getWeight(k, i, vk, vi, g, updatedEdges);
                for (int j = i + 1; j < k; ++j) {
                    Object vj = vertexOrdering[j];
                    Weight wjk = DirectionalPathConsistency.getWeight(j, k, vj, vk, g, updatedEdges);
                    if (wjk == null) continue;
                    Weight wkj = DirectionalPathConsistency.getWeight(k, j, vk, vj, g, updatedEdges);
                    Weight wikj = wik.add(wkj);
                    Weight wjki = wjk.add(wki);
                    Weight wij = DirectionalPathConsistency.getWeight(i, j, vi, vj, g, updatedEdges);
                    Weight wji = DirectionalPathConsistency.getWeight(j, i, vj, vi, g, updatedEdges);
                    Weight iwjki = wjki.invertSign();
                    Weight iwji = null;
                    if (wji != null) {
                        iwji = wji.invertSign();
                    }
                    if (wij != null) {
                        Weight intersectionMax;
                        Weight intersectionMin = Weight.max(iwji, iwjki);
                        if (intersectionMin.compareTo(intersectionMax = Weight.min(wij, wikj)) > 0) {
                            return false;
                        }
                        updatedEdges[i][j] = intersectionMax;
                        updatedEdges[j][i] = intersectionMin.invertSign();
                        continue;
                    }
                    updatedEdges[i][j] = wikj;
                    updatedEdges[j][i] = wjki;
                }
            }
        }
        return true;
    }
}

