/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.protempa.DefaultSourceIdBuilder;
import org.protempa.SourceId;

public class DefaultSourceId
implements SourceId,
Serializable {
    private static final long serialVersionUID = -8057854346978674580L;
    private static final Map<String, DefaultSourceId> CACHE = new ReferenceMap();
    private final String sourceIdStr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultSourceId getInstance(String sourceIdStr) {
        DefaultSourceId result;
        if (sourceIdStr == null) {
            throw new IllegalArgumentException("sourceIdStr cannot be null");
        }
        Map<String, DefaultSourceId> map = CACHE;
        synchronized (map) {
            result = CACHE.get(sourceIdStr);
            if (result == null) {
                result = new DefaultSourceId(sourceIdStr);
                CACHE.put(sourceIdStr, result);
            }
        }
        return result;
    }

    private DefaultSourceId(String sourceIdStr) {
        this.sourceIdStr = sourceIdStr;
    }

    @Override
    public String getStringRepresentation() {
        return this.sourceIdStr;
    }

    @Override
    public DefaultSourceIdBuilder asBuilder() {
        DefaultSourceIdBuilder builder = new DefaultSourceIdBuilder();
        builder.setSourceIdStr(this.sourceIdStr);
        return builder;
    }
}

