/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.string.StringUtil;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.dest.table.AbstractTableColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.LinkValidationFailedException;
import org.protempa.dest.table.OutputConfig;
import org.protempa.dest.table.TableColumnSpecValidationFailedException;
import org.protempa.dest.table.Util;
import org.protempa.dest.table.ValueOutputConfig;
import org.protempa.dest.table.ValueOutputConfigBuilder;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;
import org.protempa.valueset.ValueSet;

public class PropositionColumnSpec
extends AbstractTableColumnSpec {
    private static final ThreadLocal<NumberFormat> numberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getInstance();
        }
    };
    private final Link[] links;
    private final String[] propertyNames;
    private final int numInstances;
    private final String columnNamePrefixOverride;
    private final OutputConfig outputConfig;
    private final ValueOutputConfig valueOutputConfig;
    private final ValuesPropositionVisitor propositionVisitor;

    public PropositionColumnSpec(String[] propertyNames) {
        this(propertyNames, null, null);
    }

    public PropositionColumnSpec(String columnNamePrefixOverride, String[] propertyNames) {
        this(columnNamePrefixOverride, propertyNames, null, null, null, 1);
    }

    public PropositionColumnSpec(String[] propertyNames, OutputConfig outputConfig, ValueOutputConfig valueOutputConfig) {
        this(propertyNames, outputConfig, valueOutputConfig, null);
    }

    public PropositionColumnSpec(String[] propertyNames, OutputConfig outputConfig, ValueOutputConfig valueOutputConfig, Link[] links) {
        this(propertyNames, outputConfig, valueOutputConfig, links, 1);
    }

    public PropositionColumnSpec(String[] propertyNames, OutputConfig outputConfig, ValueOutputConfig valueOutputConfig, Link[] links, int numInstances) {
        this(null, propertyNames, outputConfig, valueOutputConfig, links, numInstances);
    }

    public PropositionColumnSpec(String columnNamePrefixOverride, String[] propertyNames, OutputConfig outputConfig, ValueOutputConfig valueOutputConfig, Link[] links, int numInstances) {
        if (propertyNames == null) {
            this.propertyNames = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            ProtempaUtil.checkArrayForNullElement(propertyNames, "propertyNames");
            this.propertyNames = (String[])propertyNames.clone();
            ProtempaUtil.internAll(this.propertyNames);
        }
        this.outputConfig = outputConfig == null ? new OutputConfig() : outputConfig;
        this.valueOutputConfig = valueOutputConfig == null ? new ValueOutputConfigBuilder().build() : valueOutputConfig;
        if (links == null) {
            this.links = Util.EMPTY_LINK_ARRAY;
        } else {
            ProtempaUtil.checkArrayForNullElement(links, "links");
            this.links = (Link[])links.clone();
        }
        if (numInstances < 1) {
            throw new IllegalArgumentException("numInstances cannot be < 1");
        }
        this.numInstances = numInstances;
        this.columnNamePrefixOverride = columnNamePrefixOverride;
        this.propositionVisitor = new ValuesPropositionVisitor();
    }

    private String[] columnNames() {
        ArrayList<CharSequence> results = new ArrayList<CharSequence>();
        if (this.outputConfig.showUniqueId()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getUniqueIdHeading(), (CharSequence)(this.columnNamePrefixOverride + "_uniqueId")));
        }
        if (this.outputConfig.showId()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getIdHeading(), (CharSequence)(this.columnNamePrefixOverride + "_id")));
        }
        if (this.outputConfig.showValue()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getValueHeading(), (CharSequence)(this.columnNamePrefixOverride + "_value")));
        }
        if (this.outputConfig.showDisplayName()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getDisplayNameHeading(), (CharSequence)(this.columnNamePrefixOverride + "_displayName")));
        }
        if (this.outputConfig.showAbbrevDisplayName()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getAbbrevDisplayNameHeading(), (CharSequence)(this.columnNamePrefixOverride + "_abbrevDisplayName")));
        }
        if (this.outputConfig.showStartOrTimestamp()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getStartOrTimestampHeading(), (CharSequence)(this.columnNamePrefixOverride + "_startOrTimeStamp")));
        }
        if (this.outputConfig.showFinish()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getFinishHeading(), (CharSequence)(this.columnNamePrefixOverride + "_finish")));
        }
        if (this.outputConfig.showLength()) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getLengthHeading(), (CharSequence)(this.columnNamePrefixOverride + "_length")));
        }
        for (String heading : this.propertyNames) {
            results.add(StringUtils.defaultIfEmpty((CharSequence)this.outputConfig.getPropertyHeading(heading), (CharSequence)(this.columnNamePrefixOverride + "." + heading)));
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public void columnValues(String key, Proposition proposition, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache propDefCache, Map<String, String> replace, char delimiter, Writer writer) throws IOException {
        List<Proposition> propositions = this.traverseLinks(this.links, proposition, forwardDerivations, backwardDerivations, references, propDefCache);
        this.propositionVisitor.setKnowledgeSource(propDefCache);
        String[] result = new String[this.outputConfig.getNumberOfColumns() * this.numInstances];
        this.propositionVisitor.setResult(result);
        int i = 0;
        for (Proposition prop : propositions) {
            if (i >= this.numInstances) break;
            prop.accept(this.propositionVisitor);
            ++i;
        }
        this.propositionVisitor.clear();
        StringUtil.escapeAndWriteDelimitedColumns((String[])result, replace, (char)delimiter, (Writer)writer);
    }

    @Override
    public String[] columnNames(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        String[] one = this.columnNames();
        String[] result = new String[one.length * this.numInstances];
        for (int i = 0; i < result.length; ++i) {
            result[i] = one[i % one.length];
        }
        return result;
    }

    @Override
    public void validate(KnowledgeSource knowledgeSource) throws TableColumnSpecValidationFailedException, KnowledgeSourceReadException {
        int i = 1;
        for (Link link : this.links) {
            try {
                link.validate(knowledgeSource);
            }
            catch (LinkValidationFailedException ex) {
                throw new TableColumnSpecValidationFailedException("Validation of link " + i + " failed", ex);
            }
            ++i;
        }
    }

    public Link[] getLinks() {
        return this.links;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public String getColumnNamePrefixOverride() {
        return this.columnNamePrefixOverride;
    }

    public OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    public ValueOutputConfig getValueOutputConfig() {
        return this.valueOutputConfig;
    }

    public ValuesPropositionVisitor getPropositionVisitor() {
        return this.propositionVisitor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnNamePrefixOverride == null ? 0 : this.columnNamePrefixOverride.hashCode());
        result = 31 * result + java.util.Arrays.hashCode(this.links);
        result = 31 * result + this.numInstances;
        result = 31 * result + (this.outputConfig == null ? 0 : this.outputConfig.hashCode());
        result = 31 * result + java.util.Arrays.hashCode(this.propertyNames);
        result = 31 * result + (this.valueOutputConfig == null ? 0 : this.valueOutputConfig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropositionColumnSpec other = (PropositionColumnSpec)obj;
        if (this.columnNamePrefixOverride == null ? other.columnNamePrefixOverride != null : !this.columnNamePrefixOverride.equals(other.columnNamePrefixOverride)) {
            return false;
        }
        if (!java.util.Arrays.equals(this.links, other.links)) {
            return false;
        }
        if (this.numInstances != other.numInstances) {
            return false;
        }
        if (this.outputConfig == null ? other.outputConfig != null : !this.outputConfig.equals(other.outputConfig)) {
            return false;
        }
        if (!java.util.Arrays.equals(this.propertyNames, other.propertyNames)) {
            return false;
        }
        return !(this.valueOutputConfig == null ? other.valueOutputConfig != null : !this.valueOutputConfig.equals(other.valueOutputConfig));
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        HashSet result = new HashSet();
        for (Link link : this.links) {
            inPropIds = link.getInferredPropositionIds(knowledgeSource, inPropIds);
            Arrays.addAll(result, (Object[][])new String[][]{inPropIds});
        }
        return result.toArray(new String[result.size()]);
    }

    private class ValuesPropositionVisitor
    extends AbstractPropositionVisitor {
        private KnowledgeSourceCache ksCache;
        private String[] result;
        private int i = 0;

        ValuesPropositionVisitor() {
        }

        void setKnowledgeSource(KnowledgeSourceCache ksCache) {
            this.ksCache = ksCache;
        }

        void setResult(String[] result) {
            this.result = result;
        }

        @Override
        public void visit(AbstractParameter abstractParameter) {
            Format positionFormat = PropositionColumnSpec.this.outputConfig.getPositionFormat();
            if (PropositionColumnSpec.this.outputConfig.showUniqueId()) {
                this.result[this.i++] = abstractParameter.getUniqueId().getStringRepresentation();
            }
            if (PropositionColumnSpec.this.outputConfig.showId()) {
                this.result[this.i++] = abstractParameter.getId();
            }
            if (PropositionColumnSpec.this.outputConfig.showValue()) {
                this.result[this.i++] = abstractParameter.getValueFormatted();
            }
            this.displayNames(abstractParameter);
            if (PropositionColumnSpec.this.outputConfig.showStartOrTimestamp()) {
                String string = this.result[this.i++] = positionFormat != null ? abstractParameter.formatStart(positionFormat) : abstractParameter.getStartFormattedShort();
            }
            if (PropositionColumnSpec.this.outputConfig.showFinish()) {
                String string = this.result[this.i++] = positionFormat != null ? abstractParameter.formatFinish(positionFormat) : abstractParameter.getFinishFormattedShort();
            }
            if (PropositionColumnSpec.this.outputConfig.showLength()) {
                this.result[this.i++] = ((NumberFormat)numberFormat.get()).format(abstractParameter.getInterval().getMinLength());
            }
            this.processProperties(abstractParameter);
        }

        @Override
        public void visit(Event event) {
            Format positionFormat = PropositionColumnSpec.this.outputConfig.getPositionFormat();
            if (PropositionColumnSpec.this.outputConfig.showUniqueId()) {
                this.result[this.i++] = event.getUniqueId().getStringRepresentation();
            }
            if (PropositionColumnSpec.this.outputConfig.showId()) {
                this.result[this.i++] = event.getId();
            }
            if (PropositionColumnSpec.this.outputConfig.showValue()) {
                this.result[this.i++] = null;
            }
            this.displayNames(event);
            if (PropositionColumnSpec.this.outputConfig.showStartOrTimestamp()) {
                String string = this.result[this.i++] = positionFormat != null ? event.formatStart(positionFormat) : event.getStartFormattedShort();
            }
            if (PropositionColumnSpec.this.outputConfig.showFinish()) {
                String string = this.result[this.i++] = positionFormat != null ? event.formatFinish(positionFormat) : event.getFinishFormattedShort();
            }
            if (PropositionColumnSpec.this.outputConfig.showLength()) {
                Long minLength = event.getInterval().getMinLength();
                this.result[this.i++] = minLength != null ? ((NumberFormat)numberFormat.get()).format(minLength) : "";
            }
            this.processProperties(event);
        }

        @Override
        public void visit(PrimitiveParameter primitiveParameter) {
            Format positionFormat = PropositionColumnSpec.this.outputConfig.getPositionFormat();
            if (PropositionColumnSpec.this.outputConfig.showUniqueId()) {
                this.result[this.i++] = primitiveParameter.getUniqueId().getStringRepresentation();
            }
            if (PropositionColumnSpec.this.outputConfig.showId()) {
                this.result[this.i++] = primitiveParameter.getId();
            }
            if (PropositionColumnSpec.this.outputConfig.showValue()) {
                this.result[this.i++] = primitiveParameter.getValueFormatted();
            }
            this.displayNames(primitiveParameter);
            if (PropositionColumnSpec.this.outputConfig.showStartOrTimestamp()) {
                String string = this.result[this.i++] = positionFormat != null ? primitiveParameter.formatStart(positionFormat) : primitiveParameter.getStartFormattedShort();
            }
            if (PropositionColumnSpec.this.outputConfig.showFinish()) {
                String string = this.result[this.i++] = positionFormat != null ? primitiveParameter.formatFinish(positionFormat) : primitiveParameter.getFinishFormattedShort();
            }
            if (PropositionColumnSpec.this.outputConfig.showLength()) {
                Long minLength = primitiveParameter.getInterval().getMinLength();
                this.result[this.i++] = minLength != null ? ((NumberFormat)numberFormat.get()).format(minLength) : "";
            }
            this.processProperties(primitiveParameter);
        }

        @Override
        public void visit(Constant constant) {
            if (PropositionColumnSpec.this.outputConfig.showUniqueId()) {
                this.result[this.i++] = constant.getUniqueId().getStringRepresentation();
            }
            if (PropositionColumnSpec.this.outputConfig.showId()) {
                this.result[this.i++] = constant.getId();
            }
            if (PropositionColumnSpec.this.outputConfig.showValue()) {
                this.result[this.i++] = null;
            }
            this.displayNames(constant);
            if (PropositionColumnSpec.this.outputConfig.showStartOrTimestamp()) {
                this.result[this.i++] = null;
            }
            if (PropositionColumnSpec.this.outputConfig.showFinish()) {
                this.result[this.i++] = null;
            }
            if (PropositionColumnSpec.this.outputConfig.showLength()) {
                this.result[this.i++] = null;
            }
            this.processProperties(constant);
        }

        @Override
        public void visit(Context context) {
            throw new UnsupportedOperationException("Contexts not supported yet");
        }

        void clear() {
            this.result = null;
            this.ksCache = null;
            this.i = 0;
        }

        private void displayNames(Proposition proposition) {
            boolean showDisplayName = PropositionColumnSpec.this.outputConfig.showDisplayName();
            boolean showAbbrevDisplayName = PropositionColumnSpec.this.outputConfig.showAbbrevDisplayName();
            if (showDisplayName || showAbbrevDisplayName) {
                PropositionDefinition propositionDefinition = this.ksCache.get(proposition.getId());
                if (propositionDefinition != null) {
                    if (showDisplayName) {
                        this.result[this.i++] = propositionDefinition.getDisplayName();
                    }
                    if (showAbbrevDisplayName) {
                        this.result[this.i++] = propositionDefinition.getAbbreviatedDisplayName();
                    }
                } else {
                    this.result[this.i++] = null;
                    Util.logger().log(Level.WARNING, "Cannot write display name for {0} because it is not in the knowledge source", proposition.getId());
                }
            }
        }

        private String getOutputPropertyValue(Proposition proposition, String propertyName, Value propertyValue) {
            String outputValue = null;
            boolean showDisplayName = PropositionColumnSpec.this.valueOutputConfig.isShowPropertyValueDisplayName();
            boolean showAbbrevDisplayName = PropositionColumnSpec.this.valueOutputConfig.isShowPropertyValueAbbrevDisplayName();
            if (showDisplayName || showAbbrevDisplayName) {
                PropositionDefinition propositionDef = this.ksCache.get(proposition.getId());
                if (propositionDef != null) {
                    PropertyDefinition propertyDef = propositionDef.propertyDefinition(propertyName);
                    ValueSet valueSet = this.ksCache.getValueSet(propertyDef.getValueSetId());
                    if (valueSet != null) {
                        if (showAbbrevDisplayName) {
                            outputValue = valueSet.abbrevDisplayName(propertyValue);
                        } else if (showDisplayName) {
                            outputValue = valueSet.displayName(propertyValue);
                        }
                    } else {
                        Util.logger().log(Level.WARNING, "Cannot write value set display name because value set {0} is not in the knowledge source", propertyDef.getValueSetId());
                        outputValue = propertyValue instanceof DateValue ? propertyValue.format(PropositionColumnSpec.this.outputConfig.getPositionFormat()) : propertyValue.getFormatted();
                    }
                } else {
                    Util.logger().log(Level.WARNING, "Cannot write value set display name because proposition {0} is not in the knowledgeSource", proposition.getId());
                    outputValue = propertyValue instanceof DateValue ? propertyValue.format(PropositionColumnSpec.this.outputConfig.getPositionFormat()) : propertyValue.getFormatted();
                }
            } else {
                outputValue = propertyValue instanceof DateValue ? propertyValue.format(PropositionColumnSpec.this.outputConfig.getPositionFormat()) : propertyValue.getFormatted();
            }
            return outputValue;
        }

        private void processProperties(Proposition proposition) {
            for (String propertyName : PropositionColumnSpec.this.propertyNames) {
                Value value = proposition.getProperty(propertyName);
                this.result[this.i++] = value != null ? this.getOutputPropertyValue(proposition, propertyName, value) : null;
            }
        }
    }
}

