/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.PropositionValueColumnSpec;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.AggregationTypeValueConverter;

class PropositionValueColumnSpecConverter
extends AbstractConverter {
    private static final String AGGREGATION_TYPE = "aggregationType";
    private static final String COLUMN_NAME_PREFIX_OVERRIDE = "columnNamePrefixOverride";
    private static final String LINKS = "links";

    PropositionValueColumnSpecConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return PropositionValueColumnSpec.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        PropositionValueColumnSpec columnSpec = (PropositionValueColumnSpec)source;
        String columnNameOverride = columnSpec.getColumnNamePrefixOverride();
        if (columnNameOverride != null) {
            writer.addAttribute(COLUMN_NAME_PREFIX_OVERRIDE, columnNameOverride);
        }
        AggregationTypeValueConverter aggregationConverter = new AggregationTypeValueConverter();
        writer.addAttribute(AGGREGATION_TYPE, aggregationConverter.toString((Object)columnSpec.getType()));
        writer.startNode(LINKS);
        context.convertAnother((Object)columnSpec.getLinks());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String columnNameOverride = reader.getAttribute(COLUMN_NAME_PREFIX_OVERRIDE);
        String aggregationTypeString = this.requiredAttributeValue(reader, AGGREGATION_TYPE);
        PropositionValueColumnSpec.Type aggregationType = (PropositionValueColumnSpec.Type)((Object)new AggregationTypeValueConverter().fromString(aggregationTypeString));
        reader.moveDown();
        this.expect(reader, LINKS);
        Link[] links = (Link[])context.convertAnother(null, Link[].class);
        reader.moveUp();
        this.expectNoMore(reader);
        return new PropositionValueColumnSpec(columnNameOverride, links, aggregationType);
    }
}

